/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.condition;

import java.util.Objects;
import java.util.function.Function;
import org.assertj.core.annotations.Beta;
import org.assertj.core.api.Condition;
import org.assertj.core.description.Description;
import org.assertj.core.description.JoinDescription;
import org.assertj.core.util.Lists;

@Beta
public class MappedCondition<FROM, TO>
extends Condition<FROM> {
    private Condition<TO> condition;
    private Function<FROM, TO> mapping;
    private String mappingDescription;

    public static <FROM, TO> MappedCondition<FROM, TO> mappedCondition(Function<FROM, TO> mapping, Condition<TO> condition, String mappingDescription, Object ... args) {
        Objects.requireNonNull(mappingDescription, "The given mappingDescription should not be null");
        return new MappedCondition<FROM, TO>(mapping, condition, mappingDescription.formatted(args));
    }

    public static <FROM, TO> MappedCondition<FROM, TO> mappedCondition(Function<FROM, TO> mapping, Condition<TO> condition) {
        return MappedCondition.mappedCondition(mapping, condition, "", new Object[0]);
    }

    private MappedCondition(Function<FROM, TO> mapping, Condition<TO> condition, String mappingDescription) {
        Objects.requireNonNull(condition, "The given condition should not be null");
        Objects.requireNonNull(mapping, "The given mapping function should not be null");
        this.mapping = mapping;
        this.mappingDescription = mappingDescription;
        this.condition = condition;
    }

    @Override
    public boolean matches(FROM value) {
        TO mappedObject = this.mapping.apply(value);
        String desc = this.buildMappingDescription(value, mappedObject);
        this.describedAs(desc, new Object[0]);
        return this.condition.matches(mappedObject);
    }

    protected String buildMappingDescription(FROM from, TO to) {
        return this.buildMappingDescription(from, to, true);
    }

    private String buildMappingDescription(FROM from, TO to, boolean withNested) {
        StringBuilder sb = new StringBuilder("mapped");
        if (!this.mappingDescription.isEmpty()) {
            sb.append("%n   using: %s".formatted(this.mappingDescription));
        }
        if (from == null) {
            sb.append("%n   from: %s%n".formatted(from));
        } else {
            sb.append("%n   from: <%s> %s%n".formatted(MappedCondition.className(from), from));
        }
        if (to == null) {
            sb.append("   to:   %s%n".formatted(to));
        } else {
            sb.append("   to:   <%s> %s%n".formatted(MappedCondition.className(to), to));
        }
        sb.append("   then checked:");
        if (withNested) {
            sb.append("%n      %-10s".formatted(this.condition));
        }
        return sb.toString();
    }

    @Override
    public Description conditionDescriptionWithStatus(FROM actual) {
        TO mappedObject = this.mapping.apply(actual);
        Description descriptionsWithStatus = this.condition.conditionDescriptionWithStatus(mappedObject);
        Condition.Status status = this.status(actual);
        String descriptionStart = "%s %s".formatted(new Object[]{status, this.buildMappingDescription(actual, mappedObject, false)});
        return new JoinDescription(descriptionStart, "", Lists.list(descriptionsWithStatus));
    }

    private static String className(Object object) {
        return object.getClass().getSimpleName();
    }
}

