/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0019\u001aB1\b\u0002\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u000e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0014J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0000\"\u0004\b\u0001\u0010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00160\u0018R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/DirectedAcyclicGraph;", "T", "", "adjacencyList", "", "", "vertices", "<init>", "(Ljava/util/Map;Ljava/util/Set;)V", "findNearestCommonVertex", "vertex1", "vertex2", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "getAllAncestors", "vertex", "(Ljava/lang/Object;)Ljava/util/Set;", "getDistance", "", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)I", "map", "R", "conversion", "Lkotlin/Function1;", "Builder", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDirectedAcyclicGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectedAcyclicGraph.kt\norg/jetbrains/kotlinx/dataframe/impl/DirectedAcyclicGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,177:1\n2423#2,14:178\n1869#2,2:192\n216#3,2:194\n382#4,7:196\n*S KotlinDebug\n*F\n+ 1 DirectedAcyclicGraph.kt\norg/jetbrains/kotlinx/dataframe/impl/DirectedAcyclicGraph\n*L\n93#1:178,14\n131#1:192,2\n106#1:194,2\n145#1:196,7\n*E\n"})
public final class DirectedAcyclicGraph<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<T, Set<T>> adjacencyList;
    @NotNull
    private final Set<T> vertices;

    private DirectedAcyclicGraph(Map<T, ? extends Set<? extends T>> adjacencyList, Set<? extends T> vertices) {
        this.adjacencyList = adjacencyList;
        this.vertices = vertices;
    }

    @Nullable
    public final T findNearestCommonVertex(T vertex1, T vertex2) {
        T t;
        if (!this.vertices.contains(vertex1) || !this.vertices.contains(vertex2)) {
            return null;
        }
        if (Intrinsics.areEqual(vertex1, vertex2)) {
            return vertex1;
        }
        Set<T> ancestors1 = this.getAllAncestors(vertex1);
        Set<T> ancestors2 = this.getAllAncestors(vertex2);
        if (ancestors2.contains(vertex1)) {
            return vertex1;
        }
        if (ancestors1.contains(vertex2)) {
            return vertex2;
        }
        Set commonAncestors = CollectionsKt.intersect((Iterable)ancestors1, (Iterable)ancestors2);
        if (commonAncestors.isEmpty()) {
            return null;
        }
        Iterable $this$minByOrNull$iv = commonAncestors;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            t = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                Object ancestor = minElem$iv;
                boolean bl = false;
                int minValue$iv = this.getDistance(ancestor, vertex1) + this.getDistance(ancestor, vertex2);
                do {
                    Object e$iv;
                    Object ancestor2 = e$iv = iterator$iv.next();
                    $i$a$-minByOrNull-DirectedAcyclicGraph$findNearestCommonVertex$1 = false;
                    int v$iv = this.getDistance(ancestor2, vertex1) + this.getDistance(ancestor2, vertex2);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
        }
        return t;
    }

    private final Set<T> getAllAncestors(T vertex) {
        Set ancestors = new LinkedHashSet();
        Set visited = new LinkedHashSet();
        DirectedAcyclicGraph.getAllAncestors$dfs(visited, this, ancestors, vertex);
        return ancestors;
    }

    private final int getDistance(T from, T to) {
        if (Intrinsics.areEqual(from, to)) {
            return 0;
        }
        Map distances = new LinkedHashMap();
        ArrayDeque queue = new ArrayDeque();
        queue.add(from);
        distances.put(from, 0);
        while (!((Collection)queue).isEmpty()) {
            Object current = queue.removeFirst();
            Integer n = (Integer)distances.get(current);
            if (n == null) {
                continue;
            }
            int currentDistance = n;
            Set<T> set = this.adjacencyList.get(current);
            if (set == null) continue;
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object neighbor = element$iv = iterator2.next();
                boolean bl = false;
                if (distances.containsKey(neighbor)) continue;
                distances.put(neighbor, currentDistance + 1);
                queue.add(neighbor);
                if (!Intrinsics.areEqual(neighbor, to)) continue;
                return currentDistance + 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    @NotNull
    public final <R> DirectedAcyclicGraph<R> map(@NotNull Function1<? super T, ? extends R> conversion) {
        Builder<Object> builder;
        Intrinsics.checkNotNullParameter(conversion, (String)"conversion");
        Map cache = new LinkedHashMap();
        Function1 cachedConversion = arg_0 -> DirectedAcyclicGraph.map$lambda$0(cache, conversion, arg_0);
        Builder<Object> $this$map_u24lambda_u241 = builder = new Builder<Object>();
        boolean bl = false;
        for (Map.Entry<T, Set<T>> entry : this.adjacencyList.entrySet()) {
            T from = entry.getKey();
            Set<T> to = entry.getValue();
            for (T to2 : to) {
                $this$map_u24lambda_u241.addEdge(cachedConversion.invoke(from), cachedConversion.invoke(to2));
            }
        }
        return builder.build();
    }

    private static final <T> void getAllAncestors$dfs(Set<T> visited, DirectedAcyclicGraph<T> this$0, Set<T> ancestors, T current) {
        if (visited.contains(current)) {
            return;
        }
        visited.add(current);
        Map<T, Set<T>> $this$forEach$iv = this$0.adjacencyList;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<T, Set<T>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<T, Set<T>> element$iv;
            Map.Entry<T, Set<T>> entry = element$iv = iterator2.next();
            boolean bl = false;
            T parent = entry.getKey();
            Set<T> children = entry.getValue();
            if (!children.contains(current)) continue;
            ancestors.add(parent);
            DirectedAcyclicGraph.getAllAncestors$dfs(visited, this$0, ancestors, parent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Object map$lambda$0(Map $cache, Function1 $conversion, Object it) {
        Object object;
        void $this$getOrPut$iv;
        Map map2 = $cache;
        Object key$iv = it;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Object answer$iv = $conversion.invoke(it);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return object;
    }

    public /* synthetic */ DirectedAcyclicGraph(Map adjacencyList, Set vertices, DefaultConstructorMarker $constructor_marker) {
        this(adjacencyList, vertices);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J!\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000b\u001a\u00028\u00012\u0006\u0010\f\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\rJ=\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002*\u0010\u0005\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u00070\u000f\"\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012J\"\u0010\u0013\u001a\u00020\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00170\u0016H\u0002R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/DirectedAcyclicGraph$Builder;", "T", "", "<init>", "()V", "edges", "", "Lkotlin/Pair;", "vertices", "", "addEdge", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlinx/dataframe/impl/DirectedAcyclicGraph$Builder;", "addEdges", "", "([Lkotlin/Pair;)Lorg/jetbrains/kotlinx/dataframe/impl/DirectedAcyclicGraph$Builder;", "build", "Lorg/jetbrains/kotlinx/dataframe/impl/DirectedAcyclicGraph;", "hasCycle", "", "adjacencyList", "", "", "core"})
    @SourceDebugExtension(value={"SMAP\nDirectedAcyclicGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectedAcyclicGraph.kt\norg/jetbrains/kotlinx/dataframe/impl/DirectedAcyclicGraph$Builder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,177:1\n13805#2,2:178\n1504#3:180\n1534#3,3:181\n1537#3,3:191\n1252#3,4:196\n1761#3,3:200\n1869#3,2:203\n382#4,7:184\n463#4:194\n413#4:195\n*S KotlinDebug\n*F\n+ 1 DirectedAcyclicGraph.kt\norg/jetbrains/kotlinx/dataframe/impl/DirectedAcyclicGraph$Builder\n*L\n35#1:178,2\n40#1:180\n40#1:181,3\n40#1:191,3\n41#1:196,4\n69#1:200,3\n61#1:203,2\n40#1:184,7\n41#1:194\n41#1:195\n*E\n"})
    public static final class Builder<T> {
        @NotNull
        private final List<Pair<T, T>> edges = new ArrayList();
        @NotNull
        private final Set<T> vertices = new LinkedHashSet();

        @NotNull
        public final Builder<T> addEdge(T from, T to) {
            this.edges.add(TuplesKt.to(from, to));
            this.vertices.add(from);
            this.vertices.add(to);
            return this;
        }

        @NotNull
        public final Builder<T> addEdges(Pair<? extends T, ? extends T> ... edges) {
            Intrinsics.checkNotNullParameter(edges, (String)"edges");
            Pair<? extends T, ? extends T>[] $this$forEach$iv = edges;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Pair<? extends T, ? extends T> element$iv;
                Pair<? extends T, ? extends T> pair = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Object from = pair.component1();
                Object to = pair.component2();
                this.addEdge(from, to);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DirectedAcyclicGraph<T> build() {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            Object object;
            Object value$iv$iv$iv;
            Map.Entry $this$getOrPut$iv$iv$iv;
            Map $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = this.edges;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Object object2 = $this$groupByTo$iv$iv.iterator();
            while (object2.hasNext()) {
                void it;
                Object object3;
                Object element$iv$iv = object2.next();
                Pair it2 = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-DirectedAcyclicGraph$Builder$build$adjacencyList$32 = false;
                Object key$iv$iv = it2.getFirst();
                Map map2 = destination$iv$iv;
                Object key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                Pair $i$a$-groupBy-DirectedAcyclicGraph$Builder$build$adjacencyList$32 = (Pair)element$iv$iv;
                object = list$iv$iv;
                boolean bl = false;
                object.add(it.getSecond());
            }
            Map $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            object2 = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv$iv;
                boolean bl = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                object = map3;
                boolean bl2 = false;
                Set set = CollectionsKt.toSet((Iterable)((Iterable)it.getValue()));
                object.put(k, set);
            }
            Map adjacencyList = destination$iv$iv$iv;
            if (this.hasCycle(adjacencyList)) {
                throw new IllegalStateException("Graph contains cycle");
            }
            return new DirectedAcyclicGraph(adjacencyList, this.vertices, null);
        }

        private final boolean hasCycle(Map<T, ? extends Set<? extends T>> adjacencyList) {
            boolean bl;
            block4: {
                Set visited = new LinkedHashSet();
                Set recursionStack = new LinkedHashSet();
                Iterable $this$any$iv = adjacencyList.keySet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv;
                        Object vertex = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!visited.contains(vertex) && Builder.hasCycle$dfs(recursionStack, visited, adjacencyList, vertex)) {
                            return true;
                        }
                        if (!false) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final <T> boolean hasCycle$dfs(Set<T> recursionStack, Set<T> visited, Map<T, ? extends Set<? extends T>> $adjacencyList, T vertex) {
            if (recursionStack.contains(vertex)) {
                return true;
            }
            if (visited.contains(vertex)) {
                return false;
            }
            visited.add(vertex);
            recursionStack.add(vertex);
            Set<? extends T> set = $adjacencyList.get(vertex);
            if (set != null) {
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object neighbor = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!Builder.hasCycle$dfs(recursionStack, visited, $adjacencyList, neighbor)) continue;
                    return true;
                }
            }
            recursionStack.remove(vertex);
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/DirectedAcyclicGraph$Companion;", "", "<init>", "()V", "builder", "Lorg/jetbrains/kotlinx/dataframe/impl/DirectedAcyclicGraph$Builder;", "T", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> Builder<T> builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

