/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.compiler;

import com.intellij.openapi.util.Ref;
import java.io.File;
import java.io.FilterReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.ExpandProperties;
import org.gradle.api.Transformer;
import org.gradle.util.internal.ConfigureUtil;
import org.jetbrains.jps.gradle.GradleJpsBundle;
import org.jetbrains.jps.gradle.model.impl.ResourceRootFilter;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;

public class ChainingFilterTransformer
implements Transformer<Reader, Reader> {
    private final Collection<ResourceRootFilter> myFilters = new ArrayList<ResourceRootFilter>();
    private final CompileContext myContext;
    private final Ref<File> myOutputFileRef;

    public ChainingFilterTransformer(CompileContext context, Collection<? extends ResourceRootFilter> filters, Ref<File> outputFileRef) {
        this.myContext = context;
        this.myOutputFileRef = outputFileRef;
        this.myFilters.addAll(filters);
    }

    public ChainingFilterTransformer(CompileContext context, Collection<? extends ResourceRootFilter> filters) {
        this(context, filters, null);
    }

    public void addAll(Collection<ResourceRootFilter> filters) {
        this.myFilters.addAll(filters);
    }

    public void add(ResourceRootFilter ... filters) {
        Collections.addAll(this.myFilters, filters);
    }

    public Reader transform(Reader original) {
        Reader value = original;
        for (ResourceRootFilter filter : this.myFilters) {
            value = this.doTransform(filter, value);
        }
        return value;
    }

    private Reader doTransform(ResourceRootFilter filter, Reader original) {
        if ("RenamingCopyFilter".equals(filter.filterType)) {
            Matcher matcher = (Matcher)filter.getProperties().get("matcher");
            String replacement = (String)filter.getProperties().get("replacement");
            if (matcher == null || replacement == null) {
                return original;
            }
            matcher.reset(((File)this.myOutputFileRef.get()).getName());
            if (matcher.find()) {
                String newFileName = matcher.replaceFirst(replacement);
                this.myOutputFileRef.set((Object)new File(((File)this.myOutputFileRef.get()).getParentFile(), newFileName));
            }
            return original;
        }
        try {
            Class<?> clazz = Class.forName(filter.filterType);
            if (!FilterReader.class.isAssignableFrom(clazz)) {
                this.myContext.processMessage((BuildMessage)new CompilerMessage(GradleJpsBundle.message("gradle.resources.compiler", new Object[0]), BuildMessage.Kind.WARNING, GradleJpsBundle.message("error.invalid.filter.should.extend", filter.filterType), null));
            }
            Constructor<?> constructor = clazz.getConstructor(Reader.class);
            FilterReader result = (FilterReader)constructor.newInstance(original);
            Map<Object, Object> properties = filter.getProperties();
            if (!properties.isEmpty()) {
                if (ExpandProperties.class.getName().equals(filter.filterType)) {
                    HashMap<Object, Object> antProps = new HashMap<Object, Object>(properties);
                    Project project = new Project();
                    for (Map.Entry entry : antProps.entrySet()) {
                        project.setProperty(entry.getKey().toString(), entry.getValue().toString());
                    }
                    properties.clear();
                    properties.put("project", project);
                }
                ConfigureUtil.configureByMap(properties, (Object)result);
            }
            return result;
        }
        catch (Throwable th) {
            this.myContext.processMessage((BuildMessage)new CompilerMessage(GradleJpsBundle.message("gradle.resources.compiler", new Object[0]), BuildMessage.Kind.WARNING, GradleJpsBundle.message("error.failed.to.apply.filter", filter.filterType, th.getMessage()), null));
            return original;
        }
    }
}

