/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent;
import org.jetbrains.idea.maven.server.CannotStartServerException;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001d\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"createMessageEvent", "Lcom/intellij/build/events/impl/MessageEventImpl;", "project", "Lcom/intellij/openapi/project/Project;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "e", "", "getExceptionText", "", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.maven"})
public final class MessageEventUtilsKt {
    @NotNull
    public static final MessageEventImpl createMessageEvent(@NotNull Project project, @NotNull ExternalSystemTaskId taskId, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Throwable error = e;
        String group = SyncBundle.message("build.event.title.error", new Object[0]);
        CannotStartServerException csse = (CannotStartServerException)ExceptionUtil.findCause((Throwable)e, CannotStartServerException.class);
        if (csse != null) {
            group = SyncBundle.message("build.event.title.internal.server.error", new Object[0]);
            ExecutionException executionException = (ExecutionException)ExceptionUtil.findCause((Throwable)csse, ExecutionException.class);
            error = executionException != null ? (Throwable)executionException : (Throwable)csse;
        }
        String message = MessageEventUtilsKt.getExceptionText(project, error);
        return new MessageEventImpl((Object)taskId, MessageEvent.Kind.ERROR, group, message, message);
    }

    private static final String getExceptionText(Project project, Throwable e) {
        String string;
        MavenGeneralSettings generalSettings = MavenWorkspaceSettingsComponent.getInstance(project).getSettings().getGeneralSettings();
        if (generalSettings != null && generalSettings.isPrintErrorStackTraces()) {
            String string2 = ExceptionUtil.getThrowableText((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getThrowableText(...)");
            return string2;
        }
        CharSequence charSequence = e.getLocalizedMessage();
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string3 = e.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLocalizedMessage(...)");
            return string3;
        }
        if (StringUtil.isEmpty((String)e.getMessage())) {
            String string4 = SyncBundle.message("build.event.title.error", new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        } else {
            String string5 = e.getMessage();
            string = string5;
            Intrinsics.checkNotNull((Object)string5);
        }
        return string;
    }
}

