/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.smartstepinto;

import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoContext;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariant;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariantCallExpression;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariantComprehension;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariantOperator;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PySmartStepIntoVariantVisitor
extends PyRecursiveElementVisitor {
    private static final String RERAISE = "RERAISE";
    int myVariantIndex;
    @NotNull
    private final List<PySmartStepIntoVariant> myCollector;
    @NotNull
    private final List<Pair<String, Boolean>> myVariantsFromPython;
    @NotNull
    private final PySmartStepIntoContext myContext;
    @NotNull
    private final Map<String, Integer> mySeenVariants;
    @NotNull
    private final Set<PsiElement> alreadyVisited;

    public PySmartStepIntoVariantVisitor(@NotNull List<PySmartStepIntoVariant> collector, @NotNull List<Pair<String, Boolean>> variantsFromPython, @NotNull PySmartStepIntoContext context) {
        if (collector == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(0);
        }
        if (variantsFromPython == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(2);
        }
        this.myVariantIndex = -1;
        this.mySeenVariants = Maps.newHashMap();
        this.alreadyVisited = new HashSet<PsiElement>();
        this.myCollector = collector;
        boolean shouldJump = false;
        int mid = (variantsFromPython.size() - 1) / 2;
        if (((String)variantsFromPython.get((int)(variantsFromPython.size() - 1)).first).equals(RERAISE)) {
            int i;
            for (i = 0; i < mid && ((String)variantsFromPython.get((int)i).first).equals(variantsFromPython.get((int)(mid + i)).first) && ((Boolean)variantsFromPython.get((int)i).second).booleanValue() && !((Boolean)variantsFromPython.get((int)(mid + i)).second).booleanValue(); ++i) {
            }
            if (i == mid) {
                shouldJump = true;
            }
        }
        this.myVariantsFromPython = shouldJump ? variantsFromPython.subList(mid, variantsFromPython.size() - 1) : (((String)variantsFromPython.get((int)(variantsFromPython.size() - 1)).first).equals(RERAISE) ? variantsFromPython.subList(0, variantsFromPython.size() - 1) : variantsFromPython);
        this.myContext = context;
    }

    public void visitPyCallExpression(@NotNull PyCallExpression node) {
        PsiElement ref;
        if (node == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(3);
        }
        node.acceptChildren((PsiElementVisitor)this);
        if (this.alreadyVisited.contains(node)) {
            return;
        }
        this.alreadyVisited.add((PsiElement)node);
        if (this.myVariantIndex == this.myVariantsFromPython.size() - 1) {
            return;
        }
        PyExpression callee = node.getCallee();
        if (callee == null || callee.getName() == null) {
            return;
        }
        ++this.myVariantIndex;
        int callOrder = this.getCallOrder();
        this.mySeenVariants.put((String)this.myVariantsFromPython.get((int)this.myVariantIndex).first, ++callOrder);
        PsiElement psiElement = ref = callee.getReference() != null ? callee.getReference().resolve() : null;
        if (ref != null && PySmartStepIntoVariantVisitor.isBuiltIn(ref)) {
            return;
        }
        if (LanguageLevel.forElement((PsiElement)node).isOlderThan(LanguageLevel.PYTHON312) && ref instanceof PyFunction && (((PyFunction)ref).isAsync() || ((PyFunction)ref).isGenerator())) {
            return;
        }
        if (this.isAlreadyCalled()) {
            return;
        }
        this.myCollector.add(new PySmartStepIntoVariantCallExpression(node, callOrder, this.myContext));
    }

    public void visitPyDecoratorList(@NotNull PyDecoratorList node) {
        PyDecorator[] decorators;
        if (node == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(4);
        }
        if ((decorators = node.getDecorators()).length > 0) {
            decorators[0].accept((PsiElementVisitor)this);
        }
    }

    public void visitPyComprehensionElement(@NotNull PyComprehensionElement node) {
        if (node == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(5);
        }
        node.acceptChildren((PsiElementVisitor)this);
        if (this.alreadyVisited.contains(node)) {
            return;
        }
        this.alreadyVisited.add((PsiElement)node);
        if (this.myVariantIndex == this.myVariantsFromPython.size() - 1) {
            return;
        }
        if (!PySmartStepIntoVariantComprehension.isComprehensionName((String)this.myVariantsFromPython.get((int)(this.myVariantIndex + 1)).first)) {
            return;
        }
        ++this.myVariantIndex;
        int callOrder = this.getCallOrder();
        this.mySeenVariants.put((String)this.myVariantsFromPython.get((int)this.myVariantIndex).first, ++callOrder);
        if (this.isAlreadyCalled()) {
            return;
        }
        this.myCollector.add(new PySmartStepIntoVariantComprehension(node, callOrder, this.myContext));
    }

    public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
        if (node == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(6);
        }
        node.getLeftExpression().accept((PsiElementVisitor)this);
        if (node.getRightExpression() != null) {
            node.getRightExpression().accept((PsiElementVisitor)this);
        }
        node.acceptChildren((PsiElementVisitor)this);
        if (this.alreadyVisited.contains(node)) {
            return;
        }
        this.alreadyVisited.add((PsiElement)node);
        if (this.myVariantIndex == this.myVariantsFromPython.size() - 1) {
            return;
        }
        PyElementType operator = node.getOperator();
        if (PyTokenTypes.OPERATIONS.contains((IElementType)operator)) {
            this.processOperator(operator, (PyReferenceOwner)node);
        }
    }

    public void visitPyPrefixExpression(@NotNull PyPrefixExpression node) {
        PyExpression operand;
        if (node == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(7);
        }
        if ((operand = node.getOperand()) != null) {
            operand.accept((PsiElementVisitor)this);
        }
        PyElementType operator = node.getOperator();
        this.processOperator(operator, (PyReferenceOwner)node);
    }

    private void processOperator(PyElementType operator, PyReferenceOwner expression) {
        PyReferenceOwner psiOperator;
        String specialMethodName;
        boolean isBinaryOperator = expression instanceof PyBinaryExpression;
        String string = specialMethodName = isBinaryOperator ? operator.getSpecialMethodName() : PySmartStepIntoVariantOperator.getUnaryOperatorSpecialMethodName(operator);
        if (specialMethodName == null || !specialMethodName.equals(this.myVariantsFromPython.get((int)(this.myVariantIndex + 1)).first)) {
            return;
        }
        ++this.myVariantIndex;
        int callOrder = this.getCallOrder();
        this.mySeenVariants.put((String)this.myVariantsFromPython.get((int)this.myVariantIndex).first, ++callOrder);
        TypeEvalContext context = TypeEvalContext.userInitiated((Project)expression.getProject(), (PsiFile)expression.getContainingFile());
        PsiElement resolved = expression.getReference(PyResolveContext.defaultContext((TypeEvalContext)context)).resolve();
        if (resolved == null || PySmartStepIntoVariantVisitor.isBuiltIn(resolved) || this.isAlreadyCalled()) {
            return;
        }
        Object object = psiOperator = isBinaryOperator ? ((PyBinaryExpression)expression).getPsiOperator() : expression;
        if (psiOperator != null) {
            this.myCollector.add(new PySmartStepIntoVariantOperator((PsiElement)psiOperator, callOrder, this.myContext));
        }
    }

    private static boolean isBuiltIn(@NotNull PsiElement ref) {
        PsiFile navFile;
        if (ref == null) {
            PySmartStepIntoVariantVisitor.$$$reportNull$$$0(8);
        }
        return (navFile = ref.getNavigationElement().getContainingFile()) instanceof PyFile && PyNames.BUILTINS_MODULES.contains(navFile.getContainingFile().getName()) || navFile instanceof PyiFile;
    }

    private boolean isAlreadyCalled() {
        return (Boolean)this.myVariantsFromPython.get((int)this.myVariantIndex).second;
    }

    private int getCallOrder() {
        return this.mySeenVariants.getOrDefault(this.myVariantsFromPython.get((int)this.myVariantIndex).first, -1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantsFromPython";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/smartstepinto/PySmartStepIntoVariantVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyCallExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyDecoratorList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyComprehensionElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyBinaryExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyPrefixExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isBuiltIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

