﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSightRequest.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/MemberType.h>

#include <utility>

namespace Aws {
namespace QuickSight {
namespace Model {

/**
 */
class DeleteFolderMembershipRequest : public QuickSightRequest {
 public:
  AWS_QUICKSIGHT_API DeleteFolderMembershipRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteFolderMembership"; }

  AWS_QUICKSIGHT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ID for the Amazon Web Services account that contains the folder.</p>
   */
  inline const Aws::String& GetAwsAccountId() const { return m_awsAccountId; }
  inline bool AwsAccountIdHasBeenSet() const { return m_awsAccountIdHasBeenSet; }
  template <typename AwsAccountIdT = Aws::String>
  void SetAwsAccountId(AwsAccountIdT&& value) {
    m_awsAccountIdHasBeenSet = true;
    m_awsAccountId = std::forward<AwsAccountIdT>(value);
  }
  template <typename AwsAccountIdT = Aws::String>
  DeleteFolderMembershipRequest& WithAwsAccountId(AwsAccountIdT&& value) {
    SetAwsAccountId(std::forward<AwsAccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Folder ID.</p>
   */
  inline const Aws::String& GetFolderId() const { return m_folderId; }
  inline bool FolderIdHasBeenSet() const { return m_folderIdHasBeenSet; }
  template <typename FolderIdT = Aws::String>
  void SetFolderId(FolderIdT&& value) {
    m_folderIdHasBeenSet = true;
    m_folderId = std::forward<FolderIdT>(value);
  }
  template <typename FolderIdT = Aws::String>
  DeleteFolderMembershipRequest& WithFolderId(FolderIdT&& value) {
    SetFolderId(std::forward<FolderIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the asset that you want to delete.</p>
   */
  inline const Aws::String& GetMemberId() const { return m_memberId; }
  inline bool MemberIdHasBeenSet() const { return m_memberIdHasBeenSet; }
  template <typename MemberIdT = Aws::String>
  void SetMemberId(MemberIdT&& value) {
    m_memberIdHasBeenSet = true;
    m_memberId = std::forward<MemberIdT>(value);
  }
  template <typename MemberIdT = Aws::String>
  DeleteFolderMembershipRequest& WithMemberId(MemberIdT&& value) {
    SetMemberId(std::forward<MemberIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The member type of the asset that you want to delete from a folder.</p>
   */
  inline MemberType GetMemberType() const { return m_memberType; }
  inline bool MemberTypeHasBeenSet() const { return m_memberTypeHasBeenSet; }
  inline void SetMemberType(MemberType value) {
    m_memberTypeHasBeenSet = true;
    m_memberType = value;
  }
  inline DeleteFolderMembershipRequest& WithMemberType(MemberType value) {
    SetMemberType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_awsAccountId;

  Aws::String m_folderId;

  Aws::String m_memberId;

  MemberType m_memberType{MemberType::NOT_SET};
  bool m_awsAccountIdHasBeenSet = false;
  bool m_folderIdHasBeenSet = false;
  bool m_memberIdHasBeenSet = false;
  bool m_memberTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
