/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.driver.libsql;

import com.dbeaver.jdbc.driver.libsql.LibSqlConnection;
import com.dbeaver.jdbc.driver.libsql.LibSqlConstants;
import com.dbeaver.jdbc.driver.libsql.LibSqlUtils;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LibSqlDriver
implements Driver {
    private static final Logger parentLogger;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String targetUrl = LibSqlUtils.validateAndFormatUrl(url);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        Enumeration<?> pne = info.propertyNames();
        while (pne.hasMoreElements()) {
            String propName = (String)pne.nextElement();
            props.put(propName, info.get(propName));
        }
        return new LibSqlConnection(this, targetUrl, props);
    }

    @Override
    public boolean acceptsURL(String url) {
        return LibSqlConstants.CONNECTION_URL_PATTERN.matcher(url).matches();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    public int getMicroVersion() {
        return 2;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() {
        return parentLogger;
    }

    public String getDriverName() {
        return "LibSQL";
    }

    public String getFullVersion() {
        return this.getMajorVersion() + "." + this.getMinorVersion() + "." + this.getMicroVersion() + " (DBeaver LibSQL JDBC driver)";
    }

    static {
        Logger logger;
        parentLogger = logger = Logger.getLogger("com.dbeaver.jdbc.upd.driver.driver");
        try {
            DriverManager.registerDriver(new LibSqlDriver());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not register driver", e);
        }
    }
}

