/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.valuefilter;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCellLocation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetValueController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.valuefilter.GenericFilterValueEdit;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.editors.StringInlineEditor;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class FilterValueEditDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.FilterValueEditDialog";
    private GenericFilterValueEdit handler;
    private Object value;
    private static final Log log = Log.getLog(FilterValueEditDialog.class);

    public FilterValueEditDialog(ResultSetViewer viewer, DBDAttributeBinding attr, ResultSetRow[] rows, DBCLogicalOperator operator) {
        super(viewer.getControl().getShell(), "Edit value", null);
        this.handler = new GenericFilterValueEdit(viewer, attr, rows, operator);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)("DBeaver.FilterValueEditDialog." + this.handler.getOperator().name()));
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Label label = UIUtils.createControlLabel((Composite)composite, (String)(this.handler.getAttribute().getName() + " " + this.handler.getOperator().getExpression()));
        label.setLayoutData((Object)new GridData(768));
        int argumentCount = this.handler.getOperator().getArgumentCount();
        if (argumentCount == 1) {
            this.createSingleValueEditor(composite);
        } else if (argumentCount < 0) {
            this.createMultiValueSelector(composite);
        }
        return parent;
    }

    private void createSingleValueEditor(Composite composite) {
        Composite editorPlaceholder = UIUtils.createPlaceholder((Composite)composite, (int)1);
        editorPlaceholder.setLayoutData((Object)new GridData(1808));
        editorPlaceholder.setLayout((Layout)new FillLayout());
        ResultSetRow singleRow = this.handler.getRows()[0];
        ResultSetValueController valueController = new ResultSetValueController(this, this.handler.getViewer(), new ResultSetCellLocation(this.handler.getAttribute(), singleRow, null), IValueController.EditType.INLINE, editorPlaceholder){

            @Override
            public boolean isReadOnly() {
                return false;
            }
        };
        IValueEditor editor = null;
        try {
            editor = valueController.getValueManager().createEditor(valueController);
        }
        catch (Exception e) {
            log.error((Object)"Can't create inline value editor", (Throwable)e);
        }
        if (editor == null) {
            editor = new StringInlineEditor(valueController);
        }
        this.handler.setEditor(editor);
        editor.createControl();
        try {
            editor.primeEditorValue(valueController.getValue());
        }
        catch (DBException e) {
            log.error((Object)"Error populating filter value", (Throwable)e);
        }
    }

    private void createMultiValueSelector(Composite composite) {
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 400;
        layoutData.heightHint = 300;
        this.handler.setupTable(composite, 67618, true, true, layoutData);
        ViewerColumnController columnController = new ViewerColumnController(((Object)((Object)this)).getClass().getName(), (ColumnViewer)this.handler.getTableViewer());
        columnController.addColumn("Value", "Value", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return FilterValueEditDialog.this.handler.getAttribute().getValueHandler().getValueDisplayString((DBSTypedObject)FilterValueEditDialog.this.handler.getAttribute(), ((DBDLabelValuePair)element).getValue(), DBDDisplayFormat.UI);
            }
        });
        columnController.addColumn("Description", "Row description (composed from dictionary columns)", 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(this){

            public String getText(Object element) {
                return ((DBDLabelValuePair)element).getLabel();
            }
        });
        columnController.createColumns(true);
        Action[] elements = new Action[]{new Action("Select &All"){

            public void run() {
                for (TableItem item : FilterValueEditDialog.this.handler.getTableViewer().getTable().getItems()) {
                    item.setChecked(true);
                }
            }
        }, new Action("Select &None"){

            public void run() {
                for (TableItem item : FilterValueEditDialog.this.handler.getTableViewer().getTable().getItems()) {
                    item.setChecked(false);
                }
            }
        }};
        this.handler.addContextMenu(elements);
        this.handler.addFilterText(composite);
        this.handler.setFilterPattern(null);
        this.handler.loadValues(null);
        columnController.createColumns(true);
    }

    public Object getValue() {
        return this.value;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.handler.getOperator().getArgumentCount() == 1) {
            Button copyButton = this.createButton(parent, 13, "Clipboard", false);
            copyButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.FILTER_CLIPBOARD));
        }
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            try {
                Object value = ResultSetUtils.getAttributeValueFromClipboard(this.handler.getAttribute());
                this.handler.getEditor().primeEditorValue(value);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Copy from clipboard", "Can't copy value", (Throwable)e);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.value = this.handler.getFilterValue();
        super.okPressed();
    }
}

