/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.importer;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferResultSet;
import org.jkiss.utils.CommonUtils;

public abstract class StreamImporterAbstract
implements IStreamDataImporter {
    private static final Log log = Log.getLog(StreamImporterAbstract.class);
    protected static final String PROP_TIMESTAMP_FORMAT = "timestampFormat";
    protected static final String PROP_TIMESTAMP_ZONE = "timestampZone";
    protected static final String PROP_COLUMN_TYPE_SAMPLES = "columnTypeSamplesCount";
    protected static final String PROP_COLUMN_TYPE_LENGTH = "columnTypeMinimalLength";
    protected static final String PROP_COLUMN_IS_BYTE_LENGTH = "columnTypeIsByteLength";
    protected static final String STRING_DATA_TYPE = "String";
    private IStreamDataImporterSite site;

    public IStreamDataImporterSite getSite() {
        return this.site;
    }

    @Override
    public void init(@NotNull IStreamDataImporterSite site) throws DBException {
        this.site = site;
    }

    @Override
    public void dispose() {
    }

    @Nullable
    protected DateTimeFormatter getTimeStampFormat(Map<String, Object> properties, String formatPropName) {
        DateTimeFormatter tsFormat = null;
        String tsFormatPattern = CommonUtils.toString((Object)properties.get(formatPropName));
        if (!CommonUtils.isEmpty((String)tsFormatPattern)) {
            try {
                tsFormat = DateTimeFormatter.ofPattern(tsFormatPattern);
            }
            catch (Exception e) {
                log.error((Object)("Wrong timestamp format: " + tsFormatPattern), (Throwable)e);
            }
        }
        return tsFormat;
    }

    protected void applyTransformHints(StreamTransferResultSet resultSet, IDataTransferConsumer consumer, Map<String, Object> properties, String formatPropName, String zoneIdPropName) throws DBException {
        DatabaseTransferConsumer.ColumnMapping[] zoneId;
        DateTimeFormatter tsFormat = formatPropName == null ? null : this.getTimeStampFormat(properties, formatPropName);
        ZoneId tsZoneId = null;
        if (zoneIdPropName != null && !CommonUtils.isEmpty((String)(zoneId = CommonUtils.toString((Object)properties.get(zoneIdPropName))))) {
            tsZoneId = ZoneId.of((String)zoneId);
        }
        if (tsFormat != null) {
            resultSet.setDateTimeFormat(tsFormat, tsZoneId);
        }
        if (consumer instanceof DatabaseTransferConsumer) {
            for (DatabaseTransferConsumer.ColumnMapping cm : ((DatabaseTransferConsumer)consumer).getColumnMappings()) {
                if (cm == null) continue;
                for (StreamDataImporterColumnInfo attributeMapping : resultSet.getAttributeMappings()) {
                    DBSEntityAttribute targetAttr;
                    if (!cm.targetAttr.getMappingType().isValid() || cm.sourceAttr.getDataKind() != DBPDataKind.STRING || !cm.sourceAttr.getName().equals(attributeMapping.getName()) || (targetAttr = cm.targetAttr.getTarget()) == null) continue;
                    switch (targetAttr.getDataKind()) {
                        case DATETIME: 
                        case NUMERIC: 
                        case BOOLEAN: {
                            attributeMapping.setDataKind(targetAttr.getDataKind());
                        }
                    }
                }
            }
            Object targetObject = consumer.getTargetObject();
            if (targetObject instanceof DBSEntity) {
                // empty if block
            }
        }
    }
}

