/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.xml.sax.Attributes;

class ViewerColumnRegistry {
    private static final Log log = Log.getLog(ViewerColumnRegistry.class);
    private static final String COLUMNS_CONFIG_FILE = "column_settings.xml";
    private static ViewerColumnRegistry instance;
    private final Map<String, List<ColumnState>> columnsConfig = new TreeMap<String, List<ColumnState>>();
    private volatile ConfigSaver saver = null;

    public static synchronized ViewerColumnRegistry getInstance() {
        if (instance == null) {
            instance = new ViewerColumnRegistry();
        }
        return instance;
    }

    public ViewerColumnRegistry() {
        Path columnsConfig = DBWorkbench.getPlatform().getLocalConfigurationFile(COLUMNS_CONFIG_FILE);
        if (Files.exists(columnsConfig, new LinkOption[0])) {
            this.loadConfiguration(columnsConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<ColumnState> getSavedConfig(String controlId) {
        Map<String, List<ColumnState>> map = this.columnsConfig;
        synchronized (map) {
            return this.columnsConfig.get(controlId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfig(String controlId, Collection<? extends ColumnState> columns) {
        Map<String, List<ColumnState>> map = this.columnsConfig;
        synchronized (map) {
            ArrayList<ColumnState> newStates = new ArrayList<ColumnState>(columns.size());
            for (ColumnState columnState : columns) {
                newStates.add(new ColumnState(columnState));
            }
            this.columnsConfig.put(controlId, newStates);
            if (this.saver == null) {
                this.saver = new ConfigSaver();
                this.saver.schedule(3000L);
            }
        }
    }

    private void loadConfiguration(Path configFile) {
        this.columnsConfig.clear();
        try (InputStream in = Files.newInputStream(configFile, new OpenOption[0]);){
            SAXReader parser = new SAXReader(in);
            ColumnsParser dsp = new ColumnsParser();
            parser.parse((SAXListener)dsp);
        }
        catch (Exception e) {
            log.error((Object)"Error loading columns configuration", (Throwable)e);
        }
    }

    private class ConfigSaver
    extends AbstractJob {
        ConfigSaver() {
            super("Columns configuration save");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            Map<String, List<ColumnState>> map = ViewerColumnRegistry.this.columnsConfig;
            synchronized (map) {
                this.flushConfig();
                ViewerColumnRegistry.this.saver = null;
            }
            return Status.OK_STATUS;
        }

        private void flushConfig() {
            Path configFile = DBWorkbench.getPlatform().getLocalConfigurationFile(ViewerColumnRegistry.COLUMNS_CONFIG_FILE);
            try {
                if (Files.notExists(configFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
                }
                try (OutputStream out = Files.newOutputStream(configFile, new OpenOption[0]);){
                    XMLBuilder xml = new XMLBuilder(out, GeneralUtils.UTF8_ENCODING);
                    xml.setBeautify(true);
                    try (XMLBuilder.Element ignored = xml.startElement("items");){
                        for (Map.Entry<String, List<ColumnState>> entry : ViewerColumnRegistry.this.columnsConfig.entrySet()) {
                            XMLBuilder.Element ignored2 = xml.startElement("item");
                            try {
                                xml.addAttribute("id", entry.getKey());
                                for (ColumnState column : entry.getValue()) {
                                    if (column.width == 0) continue;
                                    XMLBuilder.Element ignored3 = xml.startElement("column");
                                    try {
                                        xml.addAttribute("name", column.name);
                                        xml.addAttribute("visible", column.visible);
                                        xml.addAttribute("order", column.order);
                                        xml.addAttribute("width", column.width);
                                    }
                                    finally {
                                        if (ignored3 == null) continue;
                                        ignored3.close();
                                    }
                                }
                            }
                            finally {
                                if (ignored2 == null) continue;
                                ignored2.close();
                            }
                        }
                    }
                    xml.flush();
                }
            }
            catch (Exception e) {
                log.error((Object)"Error saving columns configuration", (Throwable)e);
            }
        }
    }

    public static class ColumnState {
        String name;
        boolean visible;
        int order;
        int width;

        public ColumnState() {
        }

        public ColumnState(ColumnState source) {
            this.name = source.name;
            this.visible = source.visible;
            this.order = source.order;
            this.width = source.width;
        }

        public String toString() {
            return this.name + ":" + this.order;
        }
    }

    private class ColumnsParser
    extends SAXListener.BaseListener {
        private List<ColumnState> curColumnState = null;

        private ColumnsParser() {
        }

        public void saxStartElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName, @NotNull Attributes attributes) {
            switch (localName) {
                case "items": {
                    break;
                }
                case "item": {
                    this.curColumnState = new ArrayList<ColumnState>();
                    ViewerColumnRegistry.this.columnsConfig.put(attributes.getValue("id"), this.curColumnState);
                    break;
                }
                case "column": {
                    if (this.curColumnState == null) break;
                    ColumnState col = new ColumnState();
                    col.name = attributes.getValue("name");
                    col.visible = CommonUtils.getBoolean((String)attributes.getValue("visible"), (boolean)true);
                    col.order = CommonUtils.toInt((Object)attributes.getValue("order"), (int)0);
                    col.width = CommonUtils.toInt((Object)attributes.getValue("width"), (int)0);
                    if (col.width <= 0) break;
                    this.curColumnState.add(col);
                }
            }
        }
    }
}

