/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableCheckConstraint;
import org.jkiss.dbeaver.ext.db2.model.DB2TableCheckConstraintColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TableCache;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2TableCheckConstraintColUsage;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public final class DB2TableCheckConstraintCache
extends JDBCCompositeCache<DB2Schema, DB2Table, DB2TableCheckConstraint, DB2TableCheckConstraintColumn> {
    private static final String SQL_CK_TAB;
    private static final String SQL_CK_ALL;

    public DB2TableCheckConstraintCache(DB2TableCache tableCache) {
        super((JDBCStructCache)tableCache, DB2Table.class, (Object)"TABNAME", (Object)"CONSTNAME");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DB2Schema db2Schema, @Nullable DB2Table forTable) throws SQLException {
        String sql = forTable != null ? SQL_CK_TAB : SQL_CK_ALL;
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, db2Schema.getName());
        if (forTable != null) {
            dbStat.setString(2, forTable.getName());
        }
        return dbStat;
    }

    @Nullable
    protected DB2TableCheckConstraint fetchObject(@NotNull JDBCSession session, @NotNull DB2Schema db2Schema, @NotNull DB2Table db2Table, @NotNull String indexName, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return new DB2TableCheckConstraint(session.getProgressMonitor(), db2Table, (ResultSet)dbResult);
    }

    @Nullable
    protected DB2TableCheckConstraintColumn[] fetchObjectRow(@NotNull JDBCSession session, @NotNull DB2Table db2Table, @NotNull DB2TableCheckConstraint object, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        String colName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLNAME");
        DB2TableColumn tableColumn = db2Table.getAttribute(session.getProgressMonitor(), colName);
        DB2TableCheckConstraintColUsage usage = (DB2TableCheckConstraintColUsage)CommonUtils.valueOf(DB2TableCheckConstraintColUsage.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"USAGE"));
        if (tableColumn == null) {
            log.debug((Object)("Column '" + colName + "' not found in table '" + db2Table.getFullyQualifiedName(DBPEvaluationContext.UI) + "' ??"));
            return null;
        }
        return new DB2TableCheckConstraintColumn[]{new DB2TableCheckConstraintColumn((AbstractTableConstraint<DB2Table, DB2TableCheckConstraintColumn>)object, tableColumn, usage)};
    }

    protected void cacheChildren(@NotNull DBRProgressMonitor monitor, @NotNull DB2TableCheckConstraint constraint, @NotNull List<DB2TableCheckConstraintColumn> rows) {
        constraint.setAttributeReferences(rows);
    }

    static {
        StringBuilder sb = new StringBuilder(512);
        sb.append(" SELECT C.*");
        sb.append("      , CK.COLNAME");
        sb.append("      , CK.USAGE");
        sb.append("   FROM SYSCAT.CHECKS C");
        sb.append("       ,SYSCAT.COLCHECKS  CK");
        sb.append("  WHERE C.TABSCHEMA = ?");
        sb.append("    AND C.TABNAME = ?");
        sb.append("    AND CK.CONSTNAME = C.CONSTNAME");
        sb.append("    AND CK.TABSCHEMA = C.TABSCHEMA");
        sb.append("    AND CK.TABNAME   = C.TABNAME");
        sb.append("  ORDER BY CK.COLNAME");
        sb.append(" WITH UR");
        SQL_CK_TAB = sb.toString();
        sb.setLength(0);
        sb.append(" SELECT C.*");
        sb.append("      , CK.COLNAME");
        sb.append("      , CK.USAGE");
        sb.append("   FROM SYSCAT.CHECKS C");
        sb.append("       ,SYSCAT.COLCHECKS  CK");
        sb.append("  WHERE C.TABSCHEMA = ?");
        sb.append("    AND CK.CONSTNAME = C.CONSTNAME");
        sb.append("    AND CK.TABSCHEMA = C.TABSCHEMA");
        sb.append("    AND CK.TABNAME   = C.TABNAME");
        sb.append("  ORDER BY CK.COLNAME");
        sb.append(" WITH UR");
        SQL_CK_ALL = sb.toString();
    }
}

