/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.util.Collections;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class LocalSystemRegistry {
    private static final Log log = Log.getLog(ApplicationPolicyProvider.class);
    private static Registry instance;

    public static Registry getInstance() {
        if (instance == null) {
            instance = RuntimeUtils.isWindows() ? new WindowsRegistry() : new VoidRegistry();
        }
        return instance;
    }

    public static interface Registry {
        public boolean registryKeyExists(String var1, String var2);

        public boolean registryValueExists(String var1, String var2, String var3);

        public String[] registryGetKeys(String var1, String var2);

        public Map<String, Object> registryGetValues(String var1, String var2);

        public String registryGetStringValue(String var1, String var2, String var3);
    }

    private static class WindowsRegistry
    implements Registry {
        private WindowsRegistry() {
        }

        @Override
        public boolean registryKeyExists(String root, String key) {
            return Advapi32Util.registryKeyExists((WinReg.HKEY)this.getRootHkey(root), (String)key);
        }

        @Override
        public boolean registryValueExists(String root, String key, String value) {
            return Advapi32Util.registryValueExists((WinReg.HKEY)this.getRootHkey(root), (String)key, (String)value);
        }

        @Override
        public String[] registryGetKeys(String root, String keyPath) {
            return Advapi32Util.registryGetKeys((WinReg.HKEY)this.getRootHkey(root), (String)keyPath);
        }

        @Override
        public Map<String, Object> registryGetValues(String root, String keyPath) {
            return Advapi32Util.registryGetValues((WinReg.HKEY)this.getRootHkey(root), (String)keyPath);
        }

        @Override
        public String registryGetStringValue(String root, String key, String value) {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)this.getRootHkey(root), (String)key, (String)value);
        }

        private WinReg.HKEY getRootHkey(String root) {
            try {
                return (WinReg.HKEY)WinReg.class.getField(root).get(null);
            }
            catch (Exception e) {
                log.debug((Object)e);
                return new WinReg.HKEY();
            }
        }
    }

    private static class VoidRegistry
    implements Registry {
        private VoidRegistry() {
        }

        @Override
        public boolean registryKeyExists(String root, String key) {
            return false;
        }

        @Override
        public boolean registryValueExists(String root, String key, String value) {
            return false;
        }

        @Override
        public String[] registryGetKeys(String root, String keyPath) {
            return new String[0];
        }

        @Override
        public Map<String, Object> registryGetValues(String root, String keyPath) {
            return Collections.emptyMap();
        }

        @Override
        public String registryGetStringValue(String root, String key, String value) {
            return null;
        }
    }
}

