/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Partition;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class InsertDeParser
extends AbstractDeParser<Insert> {
    private ExpressionVisitor<StringBuilder> expressionVisitor;
    private SelectVisitor<StringBuilder> selectVisitor;

    public InsertDeParser() {
        super(new StringBuilder());
    }

    public InsertDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, SelectVisitor<StringBuilder> selectVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(Insert insert) {
        Iterator<WithItem<Object>> iter;
        if (insert.getWithItemsList() != null && !insert.getWithItemsList().isEmpty()) {
            this.builder.append("WITH ");
            iter = insert.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem<?> withItem = iter.next();
                withItem.accept(this.selectVisitor, null);
                if (iter.hasNext()) {
                    this.builder.append(",");
                }
                this.builder.append(" ");
            }
        }
        this.builder.append("INSERT ");
        if (insert.getModifierPriority() != null) {
            this.builder.append((Object)insert.getModifierPriority()).append(" ");
        }
        if (insert.getOracleHint() != null) {
            this.builder.append(insert.getOracleHint()).append(" ");
        }
        if (insert.isModifierIgnore()) {
            this.builder.append("IGNORE ");
        }
        if (insert.isOverwrite()) {
            this.builder.append("OVERWRITE ");
        } else {
            this.builder.append("INTO ");
        }
        if (insert.isTableKeyword()) {
            this.builder.append("TABLE ");
        }
        this.builder.append(insert.getTable().toString());
        if (insert.isOnlyDefaultValues()) {
            this.builder.append(" DEFAULT VALUES");
        }
        if (insert.getColumns() != null) {
            this.builder.append(" (");
            iter = insert.getColumns().iterator();
            while (iter.hasNext()) {
                Column column = (Column)((Object)iter.next());
                this.builder.append(column.getColumnName());
                if (!iter.hasNext()) continue;
                this.builder.append(", ");
            }
            this.builder.append(")");
        }
        if (insert.isOverriding()) {
            this.builder.append("OVERRIDING SYSTEM VALUE ");
        }
        if (insert.getPartitions() != null) {
            this.builder.append(" PARTITION (");
            Partition.appendPartitionsTo(this.builder, insert.getPartitions());
            this.builder.append(")");
        }
        if (insert.getOutputClause() != null) {
            this.builder.append(insert.getOutputClause().toString());
        }
        if (insert.getSelect() != null) {
            this.builder.append(" ");
            Select select = insert.getSelect();
            select.accept(this.selectVisitor, null);
        }
        if (insert.getSetUpdateSets() != null) {
            this.builder.append(" SET ");
            InsertDeParser.deparseUpdateSets(insert.getSetUpdateSets(), this.builder, this.expressionVisitor);
        }
        if (insert.getDuplicateUpdateSets() != null) {
            this.builder.append(" ON DUPLICATE KEY UPDATE ");
            InsertDeParser.deparseUpdateSets(insert.getDuplicateUpdateSets(), this.builder, this.expressionVisitor);
        }
        if (insert.getConflictAction() != null) {
            this.builder.append(" ON CONFLICT");
            if (insert.getConflictTarget() != null) {
                insert.getConflictTarget().appendTo(this.builder);
            }
            insert.getConflictAction().appendTo(this.builder);
        }
        if (insert.getReturningClause() != null) {
            insert.getReturningClause().appendTo(this.builder);
        }
    }

    public ExpressionVisitor<StringBuilder> getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor<StringBuilder> visitor) {
        this.expressionVisitor = visitor;
    }

    public SelectVisitor<StringBuilder> getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setSelectVisitor(SelectVisitor<StringBuilder> visitor) {
        this.selectVisitor = visitor;
    }
}

