/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.SubTaskProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataTypeConverter;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociationLazy;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSInstanceLazy;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public final class DBStructUtils {
    private static final Log log = Log.getLog(DBStructUtils.class);
    private static final String INT_DATA_TYPE = "int";
    private static final String INTEGER_DATA_TYPE = "integer";
    private static final String FLOAT_DATA_TYPE = "float";
    private static final String REAL_DATA_TYPE = "real";
    private static final String DOUBLE_DATA_TYPE = "double";
    private static final String TEXT_DATA_TYPE = "text";
    private static final String VARCHAR_DATA_TYPE = "varchar";
    private static final String VARCHAR2_DATA_TYPE = "varchar2";
    private static final int DEFAULT_VARCHAR_LENGTH = 100;

    @Nullable
    public static DBSEntityReferrer getEnumerableConstraint(@NotNull DBRProgressMonitor monitor, @NotNull DBDAttributeBinding attribute) throws DBException {
        DBSEntityAttribute entityAttribute = attribute.getEntityAttribute();
        if (entityAttribute != null) {
            return DBStructUtils.getEnumerableConstraint(monitor, entityAttribute);
        }
        return null;
    }

    @Nullable
    public static DBSEntityReferrer getEnumerableConstraint(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAttribute entityAttribute) throws DBException {
        DBSDictionary dictionary;
        DBSEntity associatedEntity;
        DBSEntityReferrer constraint;
        List<DBSEntityReferrer> refs = DBUtils.getAttributeReferrers(monitor, entityAttribute, true);
        DBSEntityReferrer dBSEntityReferrer = constraint = refs.isEmpty() ? null : refs.get(0);
        if (constraint != null && (associatedEntity = DBStructUtils.getAssociatedEntity(monitor, constraint)) instanceof DBSDictionary && (dictionary = (DBSDictionary)((Object)associatedEntity)).supportsDictionaryEnumeration()) {
            return constraint;
        }
        return null;
    }

    @Nullable
    public static DBSEntity getAssociatedEntity(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityConstraint constraint) throws DBException {
        if (constraint instanceof DBSEntityAssociationLazy) {
            DBSEntityAssociationLazy associationLazy = (DBSEntityAssociationLazy)constraint;
            return associationLazy.getAssociatedEntity(monitor);
        }
        if (constraint instanceof DBSEntityAssociation) {
            DBSEntityAssociation association = (DBSEntityAssociation)constraint;
            return association.getAssociatedEntity();
        }
        return null;
    }

    public static String generateTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity table, Map<String, Object> options, boolean addComments) throws DBException {
        DBERegistry editorsRegistry = DBWorkbench.getPlatform().getEditorsRegistry();
        SQLObjectEditor entityEditor = editorsRegistry.getObjectManager(table.getClass(), SQLObjectEditor.class);
        if (entityEditor instanceof SQLTableManager) {
            SQLTableManager tableManager = (SQLTableManager)entityEditor;
            DBEPersistAction[] ddlActions = tableManager.getTableDDL(monitor, table, options);
            return SQLUtils.generateScript(table.getDataSource(), ddlActions, addComments);
        }
        log.debug("Table editor not found for " + table.getClass().getName());
        return SQLUtils.generateCommentLine(table.getDataSource(), "Can't generate DDL: table editor not found for " + table.getClass().getName());
    }

    public static String generateObjectDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, Map<String, Object> options, boolean addComments) throws DBException {
        DBERegistry editorsRegistry = DBWorkbench.getPlatform().getEditorsRegistry();
        SQLObjectEditor entityEditor = editorsRegistry.getObjectManager(object.getClass(), SQLObjectEditor.class);
        if (entityEditor != null) {
            SQLObjectEditor.ObjectCreateCommand createCommand = entityEditor.makeCreateCommand(object, options);
            DBEPersistAction[] ddlActions = createCommand.getPersistActions(monitor, DBUtils.getDefaultContext(object, true), options);
            return SQLUtils.generateScript(object.getDataSource(), ddlActions, addComments);
        }
        log.debug("Object editor not found for " + object.getClass().getName());
        return SQLUtils.generateCommentLine(object.getDataSource(), "Can't generate DDL: object editor not found for " + object.getClass().getName());
    }

    public static String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity table, Map<String, Object> options, boolean addComments) throws DBException {
        DBPScriptObject scriptObject;
        String definitionText;
        if (table instanceof DBPScriptObject && !CommonUtils.isEmpty((String)(definitionText = (scriptObject = (DBPScriptObject)((Object)table)).getObjectDefinitionText(monitor, options)))) {
            return definitionText;
        }
        return DBStructUtils.generateTableDDL(monitor, table, options, addComments);
    }

    public static <T extends DBSEntity> void generateTableListDDL(@NotNull DBRProgressMonitor monitor, @NotNull StringBuilder sql, @NotNull Collection<T> tablesOrViews, Map<String, Object> options, boolean addComments) throws DBException {
        ArrayList goodTableList = new ArrayList();
        ArrayList cycleTableList = new ArrayList();
        ArrayList viewList = new ArrayList();
        DBStructUtils.sortTableList(monitor, tablesOrViews, goodTableList, cycleTableList, viewList);
        for (Object table : goodTableList) {
            sql.append(DBStructUtils.getObjectNameComment((DBSObject)table, ModelMessages.struct_utils_object_ddl_definition));
            DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, (DBSEntity)table, options, addComments));
        }
        ArrayList<DBSEntity> goodCycleTableList = new ArrayList<DBSEntity>();
        for (DBSEntity dBSEntity : cycleTableList) {
            DBPScriptObjectExt2 dBPScriptObjectExt2;
            if (!(dBSEntity instanceof DBPScriptObjectExt2) || !(dBPScriptObjectExt2 = (DBPScriptObjectExt2)((Object)dBSEntity)).supportsObjectDefinitionOption("ddl.skipForeignKeys") || !dBPScriptObjectExt2.supportsObjectDefinitionOption("ddl.onlyForeignKeys")) continue;
            goodCycleTableList.add(dBSEntity);
        }
        cycleTableList.removeAll(goodCycleTableList);
        if (!CommonUtils.getOption(options, (String)"ddl.separateForeignKeys", (boolean)true)) {
            for (DBSEntity dBSEntity : goodCycleTableList) {
                sql.append(DBStructUtils.getObjectNameComment(dBSEntity, ModelMessages.struct_utils_object_ddl_definition));
                DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, dBSEntity, options, addComments));
            }
        } else {
            HashMap<String, Object> optionsNoFK = new HashMap<String, Object>(options);
            optionsNoFK.put("ddl.skipForeignKeys", true);
            for (DBSEntity dBSEntity : goodCycleTableList) {
                sql.append(DBStructUtils.getObjectNameComment(dBSEntity, ModelMessages.struct_utils_object_ddl_definition));
                DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, dBSEntity, (Map<String, Object>)optionsNoFK, addComments));
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(options);
            hashMap.put("ddl.onlyForeignKeys", true);
            for (DBSEntity table : goodCycleTableList) {
                sql.append(DBStructUtils.getObjectNameComment(table, ModelMessages.struct_utils_object_ddl_foreign_keys));
                DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, table, hashMap, addComments));
            }
        }
        for (DBSEntity dBSEntity : cycleTableList) {
            sql.append(DBStructUtils.getObjectNameComment(dBSEntity, ModelMessages.struct_utils_object_ddl_definition));
            DBStructUtils.addDDLLine(sql, DBStructUtils.getTableDDL(monitor, dBSEntity, options, addComments));
        }
        for (Object table : viewList) {
            String string = DBStructUtils.getObjectNameComment((DBSObject)table, ModelMessages.struct_utils_object_ddl_source);
            String string2 = DBStructUtils.getTableDDL(monitor, (DBSEntity)table, options, addComments);
            if (!string2.startsWith(string)) {
                sql.append(string);
            }
            DBStructUtils.addDDLLine(sql, string2);
        }
        monitor.done();
    }

    private static String getObjectNameComment(@NotNull DBSObject object, @NotNull String comment) {
        DBPDataSource dataSource = object.getDataSource();
        if (dataSource == null) {
            return "";
        }
        if (!dataSource.getContainer().getPreferenceStore().getBoolean("database.meta.extra.ddl.info")) {
            return "";
        }
        Object[] singleLineComments = dataSource.getSQLDialect().getSingleLineComments();
        if (ArrayUtils.isEmpty((Object[])singleLineComments)) {
            return "";
        }
        String lf = GeneralUtils.getDefaultLineSeparator();
        return ((String)singleLineComments[0]).trim() + " " + DBUtils.getObjectFullName(object, DBPEvaluationContext.DDL) + " " + comment + lf + lf;
    }

    private static void addDDLLine(StringBuilder sql, String ddl) {
        if (!CommonUtils.isEmpty((String)(ddl = ddl.trim()))) {
            sql.append(ddl);
            if (!ddl.endsWith(";")) {
                sql.append(";");
            }
            String lf = GeneralUtils.getDefaultLineSeparator();
            sql.append(lf).append(lf).append(lf);
        }
    }

    public static <T extends DBSEntity> void sortTableList(DBRProgressMonitor monitor, Collection<T> input, List<T> simpleTables, List<T> cyclicTables, List<T> views) throws DBException {
        DBSEntity table;
        monitor.beginTask("Sorting table list", input.size());
        ArrayList<DBSEntity> realTables = new ArrayList<DBSEntity>();
        for (DBSEntity entity : input) {
            if (entity instanceof DBSView || entity instanceof DBSTable && (table = (DBSTable)entity).isView()) {
                views.add(entity);
                continue;
            }
            realTables.add(entity);
        }
        SubTaskProgressMonitor proxyMonitor = new SubTaskProgressMonitor(monitor);
        Iterator iterator = realTables.iterator();
        while (iterator.hasNext() && !monitor.isCanceled()) {
            table = (DBSEntity)iterator.next();
            try {
                if (CommonUtils.isEmpty(table.getAssociations(proxyMonitor))) {
                    simpleTables.add(table);
                    iterator.remove();
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
            monitor.worked(1);
        }
        boolean refsFound = true;
        while (refsFound && !monitor.isCanceled()) {
            refsFound = false;
            Iterator iterator2 = realTables.iterator();
            while (iterator2.hasNext() && !monitor.isCanceled()) {
                DBSEntity table2 = (DBSEntity)iterator2.next();
                try {
                    boolean allGood = true;
                    for (DBSEntityAssociation ref : CommonUtils.safeCollection(table2.getAssociations(proxyMonitor))) {
                        monitor.worked(1);
                        DBSEntity refEntity = ref.getAssociatedEntity();
                        if (refEntity != null && (simpleTables.contains(refEntity) || refEntity == table2)) continue;
                        allGood = false;
                        break;
                    }
                    if (!allGood) continue;
                    simpleTables.add(table2);
                    iterator2.remove();
                    refsFound = true;
                }
                catch (DBException e) {
                    log.error(e);
                }
            }
        }
        cyclicTables.addAll(realTables);
        monitor.done();
    }

    public static String mapTargetDataType(@Nullable DBSObject objectContainer, @NotNull DBSTypedObject srcTypedObject, boolean addModifiers) {
        SQLDataTypeConverter dataTypeConverter;
        block48: {
            block49: {
                DBDAttributeBinding attributeBinding;
                boolean isBindingWithEntityAttr = false;
                if (srcTypedObject instanceof DBDAttributeBinding && (attributeBinding = (DBDAttributeBinding)srcTypedObject).getEntityAttribute() != null) {
                    isBindingWithEntityAttr = true;
                }
                if (objectContainer == null) break block48;
                if (srcTypedObject instanceof DBSEntityAttribute || isBindingWithEntityAttr) break block49;
                if (!(srcTypedObject instanceof DBSObject)) break block48;
                DBSObject dbsObject = (DBSObject)((Object)srcTypedObject);
                if (objectContainer.getDataSource() != dbsObject.getDataSource()) break block48;
            }
            DBPDataSource srcDataSource = ((DBSObject)((Object)srcTypedObject)).getDataSource();
            assert (srcDataSource != null);
            DBPDataSource tgtDataSource = objectContainer.getDataSource();
            assert (tgtDataSource != null);
            if (srcDataSource.getClass() == tgtDataSource.getClass() && addModifiers) {
                return srcTypedObject.getFullTypeName();
            }
        }
        SQLDataTypeConverter sQLDataTypeConverter = dataTypeConverter = objectContainer == null || objectContainer.getDataSource() == null ? null : DBUtils.getAdapter(SQLDataTypeConverter.class, objectContainer.getDataSource().getSQLDialect());
        if (dataTypeConverter != null && srcTypedObject instanceof DBSObject) {
            DBSObject dbsObject = (DBSObject)((Object)srcTypedObject);
            DBPDataSource srcDataSource = dbsObject.getDataSource();
            assert (srcDataSource != null);
            DBPDataSource tgtDataSource = objectContainer.getDataSource();
            String targetTypeName = dataTypeConverter.convertExternalDataType(srcDataSource.getSQLDialect(), srcTypedObject, DBUtils.getAdapter(DBPDataTypeProvider.class, tgtDataSource));
            if (targetTypeName != null) {
                return targetTypeName;
            }
        }
        Object typeName = srcTypedObject.getTypeName();
        String typeNameLower = ((String)typeName).toLowerCase(Locale.ENGLISH);
        DBPDataKind dataKind = srcTypedObject.getDataKind();
        DBPDataTypeProvider dataTypeProvider = DBUtils.getParentOfType(DBPDataTypeProvider.class, objectContainer);
        if (dataTypeProvider != null) {
            DBSDataType dataType = dataTypeProvider.getLocalDataType((String)typeName);
            if (dataType == null && ((String)typeName).contains("(") && (dataType = dataTypeProvider.getLocalDataType(SQLUtils.stripColumnTypeModifiers((String)typeName))) != null) {
                int startPos = ((String)typeName).indexOf("(");
                typeName = String.valueOf(dataType) + ((String)typeName).substring(startPos);
            }
            if (dataType == null && typeNameLower.equals(DOUBLE_DATA_TYPE) && (dataType = dataTypeProvider.getLocalDataType("DOUBLE PRECISION")) != null) {
                typeName = dataType.getTypeName();
            }
            if (dataType != null && !DBPDataKind.canConsume(dataKind, dataType.getDataKind())) {
                dataType = null;
            }
            if (dataType == null) {
                LinkedHashMap<String, DBSDataType> possibleTypes = new LinkedHashMap<String, DBSDataType>();
                for (DBSDataType dBSDataType : dataTypeProvider.getLocalDataTypes()) {
                    if (!DBPDataKind.canConsume(dBSDataType.getDataKind(), dataKind)) continue;
                    possibleTypes.put(dBSDataType.getTypeName().toLowerCase(Locale.ENGLISH), dBSDataType);
                }
                DBSDataType targetType = null;
                if (!possibleTypes.isEmpty()) {
                    targetType = (DBSDataType)possibleTypes.get(typeNameLower);
                    if (targetType == null && dataKind == DBPDataKind.NUMERIC) {
                        for (DBSDataType dBSDataType : possibleTypes.values()) {
                            if (!CommonUtils.equalObjects((Object)dBSDataType.getScale(), (Object)srcTypedObject.getScale()) || !CommonUtils.equalObjects((Object)dBSDataType.getPrecision(), (Object)srcTypedObject.getPrecision())) continue;
                            targetType = dBSDataType;
                            break;
                        }
                        if (targetType == null) {
                            if (typeNameLower.contains(FLOAT_DATA_TYPE) || typeNameLower.contains(REAL_DATA_TYPE) || srcTypedObject.getScale() != null && srcTypedObject.getScale() > 0 && srcTypedObject.getScale() <= 6) {
                                for (String string : possibleTypes.keySet()) {
                                    if (!string.contains(FLOAT_DATA_TYPE) && !string.contains(REAL_DATA_TYPE)) continue;
                                    targetType = (DBSDataType)possibleTypes.get(string);
                                    break;
                                }
                            } else if (typeNameLower.contains(DOUBLE_DATA_TYPE) || srcTypedObject.getScale() != null && srcTypedObject.getScale() > 0 && srcTypedObject.getScale() <= 15) {
                                for (String string : possibleTypes.keySet()) {
                                    if (!string.contains(DOUBLE_DATA_TYPE)) continue;
                                    targetType = (DBSDataType)possibleTypes.get(string);
                                    break;
                                }
                            } else if (INT_DATA_TYPE.equals(typeNameLower) && possibleTypes.get(INTEGER_DATA_TYPE) != null || INTEGER_DATA_TYPE.equals(typeNameLower) && possibleTypes.get(INT_DATA_TYPE) != null) {
                                targetType = INT_DATA_TYPE.equals(typeNameLower) ? (DBSDataType)possibleTypes.get(INTEGER_DATA_TYPE) : (DBSDataType)possibleTypes.get(INT_DATA_TYPE);
                            } else if (typeNameLower.contains(INT_DATA_TYPE)) {
                                for (String string : possibleTypes.keySet()) {
                                    if (!string.contains(INT_DATA_TYPE)) continue;
                                    targetType = (DBSDataType)possibleTypes.get(string);
                                    break;
                                }
                            }
                        }
                    } else if (targetType == null && dataKind == DBPDataKind.STRING && (typeNameLower.contains(TEXT_DATA_TYPE) || srcTypedObject.getMaxLength() <= 0L)) {
                        if (possibleTypes.containsKey(TEXT_DATA_TYPE)) {
                            targetType = (DBSDataType)possibleTypes.get(TEXT_DATA_TYPE);
                        } else {
                            for (Map.Entry entry : possibleTypes.entrySet()) {
                                if (!((String)entry.getKey()).endsWith(TEXT_DATA_TYPE) || ((DBSDataType)entry.getValue()).getDataKind() != DBPDataKind.STRING) continue;
                                targetType = (DBSDataType)entry.getValue();
                                break;
                            }
                        }
                    }
                }
                if (targetType == null) {
                    typeName = DBUtils.getDefaultDataTypeName(objectContainer, dataKind);
                    typeNameLower = ((String)typeName).toLowerCase(Locale.ENGLISH);
                    if (!possibleTypes.isEmpty()) {
                        targetType = (DBSDataType)possibleTypes.get(typeNameLower);
                    }
                }
                if (targetType == null && !possibleTypes.isEmpty()) {
                    targetType = (DBSDataType)possibleTypes.values().iterator().next();
                }
                if (targetType != null) {
                    typeName = targetType.getTypeName();
                }
            }
            if (dataType != null) {
                dataKind = dataType.getDataKind();
                if (((String)typeName).equalsIgnoreCase(dataType.getTypeName())) {
                    typeName = dataType.getTypeName();
                }
            }
        }
        if (addModifiers && objectContainer != null) {
            DBPDataSource dataSource = objectContainer.getDataSource();
            SQLDialect dialect = dataSource.getSQLDialect();
            String modifiers = dialect.getColumnTypeModifiers(dataSource, srcTypedObject, (String)typeName, dataKind);
            if (modifiers != null) {
                typeName = (String)typeName + modifiers;
            } else if (VARCHAR_DATA_TYPE.equals(typeNameLower) || VARCHAR2_DATA_TYPE.equals(typeNameLower)) {
                typeName = (String)typeName + "(100)";
            }
        }
        return typeName;
    }

    public static String getAttributeName(@NotNull DBSAttributeBase attribute) {
        return DBStructUtils.getAttributeName(attribute, DBPAttributeReferencePurpose.UNSPECIFIED);
    }

    public static String getAttributeName(@NotNull DBSAttributeBase attribute, DBPAttributeReferencePurpose purpose) {
        DBDAttributeBindingMeta bindingMeta;
        DBSEntityAttribute entityAttribute;
        if (attribute instanceof DBDAttributeBindingMeta && (entityAttribute = (bindingMeta = (DBDAttributeBindingMeta)attribute).getEntityAttribute()) != null) {
            attribute = entityAttribute;
        }
        return DBUtils.isPseudoAttribute(attribute) ? attribute.getName() : DBUtils.getObjectFullName(attribute, DBPEvaluationContext.DML);
    }

    public static boolean isConnectedContainer(DBPObject parent) {
        DBSInstanceLazy il;
        return !(parent instanceof DBSInstanceLazy) || (il = (DBSInstanceLazy)parent).isInstanceConnected();
    }

    public static List<DBSObject> getRelatedDBSEntities(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject dbsObject) throws DBException {
        LinkedHashSet<DBSEntity> result;
        block6: {
            DBSObjectContainer container;
            Collection<? extends DBSObject> children;
            block5: {
                result = new LinkedHashSet<DBSEntity>();
                if (!(dbsObject instanceof DBSEntity)) break block5;
                DBSEntity mainEntity = (DBSEntity)dbsObject;
                result.add(mainEntity);
                try {
                    List<DBSEntityAssociation> associations = DBVUtils.getAllAssociations(monitor, mainEntity);
                    for (DBSEntityAssociation dBSEntityAssociation : associations) {
                        DBSEntity associatedEntity = dBSEntityAssociation.getAssociatedEntity();
                        if (associatedEntity == null) continue;
                        result.add(associatedEntity);
                    }
                }
                catch (DBException e) {
                    log.warn("Can't load associations for " + mainEntity.getName(), e);
                }
                List<DBSEntityAssociation> references = DBVUtils.getAllReferences(monitor, mainEntity);
                for (DBSEntityAssociation dBSEntityAssociation : references) {
                    DBSEntity parent = dBSEntityAssociation.getParentObject();
                    result.add(parent);
                }
                break block6;
            }
            if (!(dbsObject instanceof DBSObjectContainer) || (children = (container = (DBSObjectContainer)dbsObject).getChildren(monitor)) == null) break block6;
            for (DBSObject dBSObject : children) {
                if (!(dBSObject instanceof DBSEntity)) continue;
                DBSEntity resultChild = (DBSEntity)dBSObject;
                result.add(resultChild);
            }
        }
        return result.stream().toList();
    }

    public static boolean isSchemasSupported(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBCExecutionContextDefaults contextDefaults;
        DBCExecutionContext defaultContext = DBUtils.getDefaultContext(dataSourceContainer, false);
        return defaultContext != null && (contextDefaults = defaultContext.getContextDefaults()) != null && (contextDefaults.getDefaultSchema() != null || contextDefaults.getDefaultCatalog() != null || contextDefaults.supportsSchemaChange() || contextDefaults.supportsCatalogChange());
    }

    @Nullable
    public static String getObjectSchema(@NotNull DBSObject dbsObject) {
        if (dbsObject instanceof DBSSchema) {
            return dbsObject.getName();
        }
        for (DBSObject parent = dbsObject; parent != null; parent = parent.getParentObject()) {
            if (!(parent instanceof DBSSchema)) continue;
            return parent.getName();
        }
        return null;
    }

    @Nullable
    public static String getObjectCatalog(@NotNull DBSObject dbsObject) {
        DBSObject parent;
        if (dbsObject instanceof DBSCatalog) {
            return dbsObject.getName();
        }
        if (dbsObject instanceof DBSSchema && (parent = dbsObject.getParentObject()) instanceof DBSCatalog) {
            return parent.getName();
        }
        for (parent = dbsObject; parent != null; parent = parent.getParentObject()) {
            if (!(parent instanceof DBSCatalog)) continue;
            return parent.getName();
        }
        return null;
    }

    public static boolean isPrimaryKey(@NotNull DBSTableColumn column) {
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        try {
            return DBStructUtils.matchesColumnInRefs(monitor, column, DBStructUtils.referrers(column.getParentObject().getConstraints(monitor), DBSEntityConstraintType.PRIMARY_KEY));
        }
        catch (DBException e) {
            log.debug("Error reading primary key constraints for column: " + column.getName(), e);
            return false;
        }
    }

    public static boolean isForeignKey(@NotNull DBSTableColumn column) {
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        try {
            return DBStructUtils.matchesColumnInRefs(monitor, column, DBStructUtils.referrers(column.getParentObject().getAssociations(monitor), DBSEntityConstraintType.FOREIGN_KEY));
        }
        catch (DBException e) {
            log.debug("Error reading foreign key associations for column: " + column.getName(), e);
            return false;
        }
    }

    private static boolean matchesColumnInRefs(@Nullable DBRProgressMonitor monitor, @NotNull DBSTableColumn column, @NotNull Stream<DBSEntityReferrer> referrers) {
        return referrers.flatMap(ref -> DBStructUtils.safeRefs(monitor, ref)).anyMatch(r -> r.getAttribute() == column);
    }

    @NotNull
    private static Stream<? extends DBSEntityAttributeRef> safeRefs(@Nullable DBRProgressMonitor monitor, @NotNull DBSEntityReferrer ref) {
        try {
            List<? extends DBSEntityAttributeRef> refs = ref.getAttributeReferences(monitor);
            return refs == null ? Stream.empty() : refs.stream();
        }
        catch (DBException e) {
            log.debug("Failed to read attribute references for constraint: " + ref.getName(), e);
            return Stream.empty();
        }
    }

    @NotNull
    private static Stream<DBSEntityReferrer> referrers(@Nullable Collection<? extends DBSEntityConstraint> refs, @NotNull DBSEntityConstraintType filter) {
        if (refs == null || refs.isEmpty()) {
            return Stream.empty();
        }
        return refs.stream().filter(a -> a.getConstraintType() == filter).filter(DBSEntityReferrer.class::isInstance).map(DBSEntityReferrer.class::cast);
    }
}

