/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.compare.simple;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.SubTaskProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.properties.DataSourcePropertyFilter;
import org.jkiss.dbeaver.runtime.properties.ILazyPropertyLoadListener;
import org.jkiss.dbeaver.runtime.properties.IPropertyFilter;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertiesContributor;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.tools.compare.simple.CompareObjectsSettings;
import org.jkiss.dbeaver.tools.compare.simple.CompareReport;
import org.jkiss.dbeaver.tools.compare.simple.CompareReportLine;
import org.jkiss.dbeaver.tools.compare.simple.CompareReportProperty;
import org.jkiss.dbeaver.tools.compare.simple.CompareUtils;

public class CompareObjectsExecutor {
    private static final Log log = Log.getLog(CompareObjectsExecutor.class);
    private final Object PROPS_LOCK = new Object();
    private CompareObjectsSettings settings;
    private final List<DBNDatabaseNode> rootNodes;
    private final Map<DBPDataSource, DataSourcePropertyFilter> dataSourceFilters = new IdentityHashMap<DBPDataSource, DataSourcePropertyFilter>();
    private final DBRProgressListener initializeFinisher;
    private final ILazyPropertyLoadListener lazyPropertyLoadListener;
    private volatile int initializedCount = 0;
    private volatile IStatus initializeError;
    private final Map<Object, Map<DBPPropertyDescriptor, Object>> propertyValues = new IdentityHashMap<Object, Map<DBPPropertyDescriptor, Object>>();
    private final List<CompareReportLine> reportLines = new ArrayList<CompareReportLine>();
    private int reportDepth = 0;
    private CompareReportLine lastLine;

    private void reportObjectsCompareBegin(List<DBNDatabaseNode> objects) {
        ++this.reportDepth;
        this.lastLine = new CompareReportLine();
        this.lastLine.depth = this.reportDepth;
        this.lastLine.structure = objects.get(0);
        this.lastLine.nodes = new DBNDatabaseNode[this.rootNodes.size()];
        block0: for (int i = 0; i < this.rootNodes.size(); ++i) {
            for (DBNDatabaseNode node : objects) {
                if (node != this.rootNodes.get(i) && !node.isChildOf((DBNNode)this.rootNodes.get(i))) continue;
                this.lastLine.nodes[i] = node;
                continue block0;
            }
        }
        for (DBNDatabaseNode node : this.lastLine.nodes) {
            if (node != null) continue;
            this.lastLine.hasDifference = true;
            break;
        }
        this.reportLines.add(this.lastLine);
    }

    private void reportPropertyCompare(ObjectPropertyDescriptor property) {
        CompareReportProperty reportProperty = new CompareReportProperty(property);
        reportProperty.values = new Object[this.rootNodes.size()];
        for (int i = 0; i < this.lastLine.nodes.length; ++i) {
            Map<DBPPropertyDescriptor, Object> valueMap;
            DBNDatabaseNode node = this.lastLine.nodes[i];
            if (node == null || (valueMap = this.propertyValues.get(node.getObject())) == null) continue;
            reportProperty.values[i] = valueMap.get(property);
        }
        if (this.lastLine.properties == null) {
            this.lastLine.properties = new ArrayList<CompareReportProperty>();
        }
        this.lastLine.properties.add(reportProperty);
        Object firstValue = reportProperty.values[0];
        for (int i = 1; i < this.rootNodes.size(); ++i) {
            if (CompareUtils.equalPropertyValues(reportProperty.values[i], firstValue)) continue;
            this.lastLine.hasDifference = true;
            break;
        }
    }

    private void reportObjectsCompareEnd() {
        --this.reportDepth;
    }

    public CompareObjectsExecutor(CompareObjectsSettings settings) {
        this.settings = settings;
        this.rootNodes = settings.getNodes();
        this.initializeFinisher = new DBRProgressListener(){

            public void onTaskFinished(IStatus status) {
                if (!status.isOK()) {
                    CompareObjectsExecutor.this.initializeError = status;
                } else {
                    ++CompareObjectsExecutor.this.initializedCount;
                }
            }
        };
        this.lazyPropertyLoadListener = new ILazyPropertyLoadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handlePropertyLoad(Object object, DBPPropertyDescriptor property, Object propertyValue, boolean completed) {
                Map<Object, Map<DBPPropertyDescriptor, Object>> map = CompareObjectsExecutor.this.propertyValues;
                synchronized (map) {
                    Map<DBPPropertyDescriptor, Object> objectProps = CompareObjectsExecutor.this.propertyValues.get(object);
                    if (objectProps != null) {
                        objectProps.put(property, propertyValue);
                    }
                }
            }
        };
        PropertiesContributor.getInstance().addLazyListener(this.lazyPropertyLoadListener);
    }

    public IStatus getInitializeError() {
        return this.initializeError;
    }

    public void dispose() {
        PropertiesContributor.getInstance().removeLazyListener(this.lazyPropertyLoadListener);
    }

    public CompareReport compareObjects(DBRProgressMonitor monitor, List<DBNDatabaseNode> nodes) throws DBException, InterruptedException {
        this.reportLines.clear();
        this.lastLine = null;
        this.compareNodes(monitor, nodes);
        return new CompareReport(this.rootNodes, this.reportLines);
    }

    private void compareNodes(DBRProgressMonitor monitor, List<DBNDatabaseNode> nodes) throws DBException, InterruptedException {
        this.reportObjectsCompareBegin(nodes);
        try {
            if (nodes.size() > 1) {
                if (!(nodes.get(0) instanceof DBNDatabaseFolder)) {
                    this.compareProperties(monitor, nodes);
                }
                this.compareChildren(monitor, nodes);
            }
        }
        finally {
            this.reportObjectsCompareEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareProperties(DBRProgressMonitor monitor, List<DBNDatabaseNode> nodes) throws DBException, InterruptedException {
        boolean onlyStruct = this.settings.isCompareOnlyStructure();
        this.initializedCount = 0;
        this.initializeError = null;
        this.propertyValues.clear();
        StringBuilder title = new StringBuilder();
        monitor.subTask("Initialize nodes");
        for (DBNDatabaseNode node : nodes) {
            if (title.length() > 0) {
                title.append(", ");
            }
            title.append(node.getNodeFullName());
            node.initializeNode(null, this.initializeFinisher);
            monitor.worked(1);
        }
        while (this.initializedCount != nodes.size()) {
            if (this.initializeError != null) {
                throw new DBException(this.initializeError.getMessage());
            }
            Thread.sleep(50L);
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException();
        }
        monitor.subTask("Compare " + title.toString());
        boolean compareLazyProperties = false;
        DBNDatabaseNode firstNode = nodes.get(0);
        List properties = ObjectPropertyDescriptor.extractAnnotations(null, (Class)ObjectPropertyDescriptor.getObjectClass((Object)firstNode.getObject()), (IPropertyFilter)this.getDataSourceFilter(firstNode), null);
        for (ObjectPropertyDescriptor prop : properties) {
            if (!prop.isLazy()) continue;
            compareLazyProperties = true;
            break;
        }
        boolean compareScripts = compareLazyProperties && this.settings.isCompareScripts();
        boolean bl = compareLazyProperties = compareLazyProperties && this.settings.isCompareLazyProperties();
        if (onlyStruct && !compareScripts) {
            return;
        }
        for (DBNDatabaseNode node : nodes) {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            DBSObject databaseObject = node.getObject();
            Map<DBPPropertyDescriptor, Object> nodeProperties = this.propertyValues.get(databaseObject);
            if (nodeProperties == null) {
                nodeProperties = new IdentityHashMap<DBPPropertyDescriptor, Object>();
                this.propertyValues.put(databaseObject, nodeProperties);
            }
            PropertyCollector propertySource = new PropertyCollector((Object)databaseObject, compareLazyProperties || compareScripts);
            for (ObjectPropertyDescriptor prop : properties) {
                boolean isScriptProperty;
                boolean bl2 = isScriptProperty = prop.getId().equals("objectDefinitionText") || prop.getId().equals("extendedDefinitionText");
                if (!prop.isLazy() ? prop.isHidden() : !compareLazyProperties && (!compareScripts || !isScriptProperty)) continue;
                if (onlyStruct && !isScriptProperty) continue;
                Object propertyValue = propertySource.getPropertyValue(monitor, (Object)databaseObject, prop, true);
                Object object = this.PROPS_LOCK;
                synchronized (object) {
                    if (propertyValue instanceof DBPNamedObject) {
                        propertyValue = ((DBPNamedObject)propertyValue).getName();
                    }
                    nodeProperties.put((DBPPropertyDescriptor)prop, propertyValue);
                }
            }
            monitor.worked(1);
        }
        for (ObjectPropertyDescriptor prop : properties) {
            this.reportPropertyCompare(prop);
        }
    }

    private void compareChildren(DBRProgressMonitor monitor, List<DBNDatabaseNode> nodes) throws DBException, InterruptedException {
        int nodeCount = nodes.size();
        ArrayList<DBNDatabaseNode[]> allChildren = new ArrayList<DBNDatabaseNode[]>(nodeCount);
        SubTaskProgressMonitor subMonitor = new SubTaskProgressMonitor(monitor);
        for (int i = 0; i < nodeCount; ++i) {
            DBNDatabaseNode node = nodes.get(i);
            if (node.getObject() instanceof DBSObjectContainer) {
                ((DBSObjectContainer)node.getObject()).cacheStructure((DBRProgressMonitor)subMonitor, 7);
            }
            try {
                DBNDatabaseNode[] children = node.getChildren((DBRProgressMonitor)subMonitor);
                if (children == null) continue;
                allChildren.add(children);
                continue;
            }
            catch (Exception e) {
                log.warn((Object)"Error reading child nodes for compare", (Throwable)e);
                allChildren.add(null);
            }
        }
        LinkedHashSet<String> allChildNames = new LinkedHashSet<String>();
        for (DBNDatabaseNode[] childList : allChildren) {
            if (childList == null) continue;
            for (DBNDatabaseNode child : childList) {
                DBXTreeNode meta = child.getMeta();
                if (meta.isVirtual() || this.settings.isSkipSystemObjects() && DBUtils.isSystemObject((Object)child.getObject())) continue;
                allChildNames.add(child.getNodeDisplayName());
            }
        }
        for (String childName : allChildNames) {
            int[] childIndexes = new int[nodeCount];
            block6: for (int i = 0; i < nodeCount; ++i) {
                childIndexes[i] = -1;
                DBNDatabaseNode[] childList = (DBNDatabaseNode[])allChildren.get(i);
                if (childList == null) continue;
                for (int k = 0; k < childList.length; ++k) {
                    DBNDatabaseNode child = childList[k];
                    if (!child.getNodeDisplayName().equals(childName)) continue;
                    childIndexes[i] = k;
                    continue block6;
                }
            }
            ArrayList<DBNDatabaseNode> nodesToCompare = new ArrayList<DBNDatabaseNode>(nodeCount);
            for (int i = 0; i < nodeCount; ++i) {
                if (childIndexes[i] == -1) continue;
                for (int k = 0; k < nodeCount && (k == i || childIndexes[k] == childIndexes[i]); ++k) {
                }
                DBNDatabaseNode[] childList = (DBNDatabaseNode[])allChildren.get(i);
                if (childList == null) continue;
                nodesToCompare.add(childList[childIndexes[i]]);
            }
            this.compareNodes(monitor, nodesToCompare);
        }
    }

    private DataSourcePropertyFilter getDataSourceFilter(DBNDatabaseNode node) {
        DBPDataSource dataSource = node.getDataSourceContainer().getDataSource();
        if (dataSource == null) {
            return null;
        }
        DataSourcePropertyFilter filter = this.dataSourceFilters.get(dataSource);
        if (filter == null) {
            filter = new DataSourcePropertyFilter(dataSource);
            this.dataSourceFilters.put(dataSource, filter);
        }
        return filter;
    }
}

