/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager2;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.layout.LayoutUtil;

public class StackableLayout
implements LayoutManager2 {
    private Container container;
    private Component component;
    private boolean autoShowFirstComponent = true;
    private boolean useSelectedComponentSize;

    public StackableLayout(Container container) {
        this.container = container;
    }

    public boolean usesSelectedComponentSize() {
        return this.useSelectedComponentSize;
    }

    public boolean isAutoShowFirstComponent() {
        return this.autoShowFirstComponent;
    }

    public void setAutoShowFirstComponent(boolean autoShowFirstComponent) {
        this.autoShowFirstComponent = autoShowFirstComponent;
    }

    public void setUseSelectedComponentSize(boolean useSelectedComponentSize) {
        if (this.useSelectedComponentSize != useSelectedComponentSize) {
            this.useSelectedComponentSize = useSelectedComponentSize;
            ComponentUtil.validate(this.container);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return LayoutUtil.add(LayoutUtil.getMinMaximumSize(target.getComponents()), target.getInsets());
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        comp.setVisible(this.autoShowFirstComponent && comp.getParent().getComponentCount() == 1);
        if (comp.isVisible()) {
            this.component = comp;
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (comp == this.component) {
            this.component = null;
        }
        comp.setVisible(true);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return LayoutUtil.add(this.useSelectedComponentSize ? (this.component == null ? new Dimension(0, 0) : this.component.getPreferredSize()) : LayoutUtil.getMaxPreferredSize(parent.getComponents()), parent.getInsets());
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return LayoutUtil.add(LayoutUtil.getMaxMinimumSize(parent.getComponents()), parent.getInsets());
    }

    @Override
    public void layoutContainer(Container parent) {
        Component[] c = parent.getComponents();
        Insets parentInsets = parent.getInsets();
        Dimension size = LayoutUtil.getInteriorSize(parent);
        int i = 0;
        while (i < c.length) {
            c[i].setBounds(parentInsets.left, parentInsets.top, size.width, size.height);
            ++i;
        }
    }

    public Component getVisibleComponent() {
        return this.component;
    }

    public void showComponent(Component c) {
        boolean hasFocus;
        Component oldComponent = this.component;
        if (oldComponent == c) {
            return;
        }
        this.component = c;
        boolean bl = hasFocus = oldComponent != null && LayoutUtil.isDescendingFrom(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), oldComponent);
        if (oldComponent != null) {
            oldComponent.setVisible(false);
        }
        if (this.component != null) {
            this.component.setVisible(true);
            if (hasFocus) {
                ComponentUtil.smartRequestFocus(this.component);
            }
        }
    }
}

