/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSRule;
import io.sf.carte.doc.style.css.CSSRuleList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

class AbstractRuleList<T extends CSSRule>
extends ArrayList<T>
implements CSSRuleList<T> {
    private static final long serialVersionUID = 2L;

    public AbstractRuleList(int initialCapacity) {
        super(initialCapacity);
    }

    public AbstractRuleList() {
        super(16);
    }

    public AbstractRuleList(Collection<? extends T> c) {
        super(c);
    }

    @Override
    public int getLength() {
        return this.size();
    }

    @Override
    public T item(int index) {
        if (index >= this.getLength() || index < 0) {
            return null;
        }
        return (T)((CSSRule)this.get(index));
    }

    public boolean append(T rule) {
        return super.add(rule);
    }

    @Override
    public String toMinifiedString() {
        int sz = this.size();
        StringBuilder sb = new StringBuilder(sz * 20);
        for (int i = 0; i < sz; ++i) {
            sb.append(this.item(i).getMinifiedCssText());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        int sz = this.size();
        StringBuilder sb = new StringBuilder(sz * 20);
        for (int i = 0; i < sz; ++i) {
            org.w3c.dom.css.CSSRule rule = this.item(i);
            sb.append(rule.getCssText()).append('\n');
        }
        return sb.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            org.w3c.dom.css.CSSRule rule = this.item(i);
            rule.writeCssText(wri, context);
        }
    }
}

