/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.property.DimensionalEvaluator;
import io.sf.carte.doc.style.css.property.FunctionValue;
import org.w3c.dom.DOMException;

public class MathFunctionValue
extends FunctionValue
implements CSSMathFunctionValue {
    private static final long serialVersionUID = 1L;
    private final CSSMathFunctionValue.MathFunction functionType;
    private boolean roundResult = false;

    MathFunctionValue(CSSMathFunctionValue.MathFunction functionIndex) {
        super(CSSValue.Type.MATH_FUNCTION);
        this.functionType = functionIndex;
    }

    MathFunctionValue(MathFunctionValue copied) {
        super(copied);
        this.functionType = copied.functionType;
    }

    @Override
    public CSSMathFunctionValue.MathFunction getFunction() {
        return this.functionType;
    }

    @Override
    public int getFunctionIndex() {
        return this.functionType.ordinal();
    }

    @Override
    public void setExpectInteger() {
        this.roundResult = true;
    }

    @Override
    public boolean isExpectingInteger() {
        return this.roundResult;
    }

    @Override
    public short computeUnitType() {
        short unit;
        DimensionalEvaluator eval = new DimensionalEvaluator();
        try {
            unit = eval.computeUnitType(this);
        }
        catch (DOMException e) {
            unit = 255;
        }
        return unit;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax syntax) {
        if (syntax == null) {
            return CSSValueSyntax.Match.FALSE;
        }
        return this.dimensionalAnalysis(syntax, true);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        return this.dimensionalAnalysis(syntax, false);
    }

    private CSSValueSyntax.Match dimensionalAnalysis(CSSValueSyntax syntax, boolean followComponents) {
        CSSValueSyntax.Category result;
        DimensionalEvaluator eval = new DimensionalEvaluator();
        try {
            result = eval.dimensionalAnalysis(this);
        }
        catch (DOMException e) {
            if (eval.hasUnknownFunction() && syntax.getCategory() == CSSValueSyntax.Category.universal) {
                return CSSValueSyntax.Match.TRUE;
            }
            return CSSValueSyntax.Match.FALSE;
        }
        if (syntax.getCategory() == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        boolean lengthPercentageL = false;
        boolean lengthPercentageP = false;
        do {
            CSSValueSyntax.Category cat;
            if ((cat = syntax.getCategory()) == result) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (cat == CSSValueSyntax.Category.lengthPercentage && (result == CSSValueSyntax.Category.length || result == CSSValueSyntax.Category.percentage) || cat == CSSValueSyntax.Category.integer && result == CSSValueSyntax.Category.number) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (result != CSSValueSyntax.Category.lengthPercentage) continue;
            if (cat == CSSValueSyntax.Category.length) {
                if (lengthPercentageP) {
                    return CSSValueSyntax.Match.TRUE;
                }
                lengthPercentageL = true;
                continue;
            }
            if (cat != CSSValueSyntax.Category.percentage) continue;
            if (lengthPercentageL) {
                return CSSValueSyntax.Match.TRUE;
            }
            lengthPercentageP = true;
        } while (followComponents && (syntax = syntax.getNext()) != null);
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.functionType.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MathFunctionValue other = (MathFunctionValue)obj;
        return this.functionType == other.functionType;
    }

    @Override
    public MathFunctionValue clone() {
        return new MathFunctionValue(this);
    }
}

