/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.script.rhino;

import io.sf.carte.echosvg.script.rhino.EchoSVGSecurityController;
import io.sf.carte.echosvg.script.rhino.RhinoClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;

class SMSecurityController
extends EchoSVGSecurityController {
    @Override
    public GeneratedClassLoader createClassLoader(ClassLoader parentLoader, Object securityDomain) {
        if (securityDomain instanceof RhinoClassLoader) {
            return (RhinoClassLoader)securityDomain;
        }
        throw new SecurityException("Script() objects are not supported");
    }

    @Override
    Object getAccessControlObject(ProtectionDomain protectionDomain) {
        return new AccessControlContext(new ProtectionDomain[]{protectionDomain});
    }

    @Override
    public Object getDynamicSecurityDomain(Object securityDomain) {
        if (securityDomain != null) {
            return securityDomain;
        }
        return AccessController.getContext();
    }

    @Override
    public Object callWithDomain(Object securityDomain, final Context cx, final Callable callable, final Scriptable scope, final Scriptable thisObj, final Object[] args) {
        AccessControlContext acc;
        if (securityDomain instanceof AccessControlContext) {
            acc = (AccessControlContext)securityDomain;
        } else {
            RhinoClassLoader loader = (RhinoClassLoader)securityDomain;
            acc = (AccessControlContext)loader.getAccessControlObject();
        }
        PrivilegedExceptionAction<Object> execAction = new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() {
                return callable.call(cx, scope, thisObj, args);
            }
        };
        try {
            return AccessController.doPrivileged(execAction, acc);
        }
        catch (Exception e) {
            throw new WrappedException((Throwable)e);
        }
    }
}

