/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class ResponsePassword
extends QueryResponseRecord {
    public boolean changeSuccessful = false;
    public String errorMessage = null;

    public ResponsePassword() {
        super("responsepassword");
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name);
        fwrite.append(" success=\"");
        SpecXmlUtils.encodeBoolean((boolean)this.changeSuccessful);
        fwrite.append("\">");
        if (this.errorMessage != null) {
            SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.errorMessage);
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        XmlElement el = parser.start(new String[]{this.name});
        this.changeSuccessful = SpecXmlUtils.decodeBoolean((String)el.getAttribute("success"));
        this.errorMessage = parser.end().getText();
        if (this.errorMessage != null && this.errorMessage.length() == 0) {
            this.errorMessage = null;
        }
    }
}

