/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.opcodes;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OpCode {
    DO_NOT_USE_ME_I_AM_ENUM_ELEMENT_ZERO("BLANK"),
    CPUI_COPY("COPY"),
    CPUI_LOAD("LOAD"),
    CPUI_STORE("STORE"),
    CPUI_BRANCH("BRANCH"),
    CPUI_CBRANCH("CBRANCH"),
    CPUI_BRANCHIND("BRANCHIND"),
    CPUI_CALL("CALL"),
    CPUI_CALLIND("CALLIND"),
    CPUI_CALLOTHER("CALLOTHER"),
    CPUI_RETURN("RETURN"),
    CPUI_INT_EQUAL("INT_EQUAL"),
    CPUI_INT_NOTEQUAL("INT_NOTEQUAL"),
    CPUI_INT_SLESS("INT_SLESS"),
    CPUI_INT_SLESSEQUAL("INT_SLESSEQUAL"),
    CPUI_INT_LESS("INT_LESS"),
    CPUI_INT_LESSEQUAL("INT_LESSEQUAL"),
    CPUI_INT_ZEXT("INT_ZEXT"),
    CPUI_INT_SEXT("INT_SEXT"),
    CPUI_INT_ADD("INT_ADD"),
    CPUI_INT_SUB("INT_SUB"),
    CPUI_INT_CARRY("INT_CARRY"),
    CPUI_INT_SCARRY("INT_SCARRY"),
    CPUI_INT_SBORROW("INT_SBORROW"),
    CPUI_INT_2COMP("INT_2COMP"),
    CPUI_INT_NEGATE("INT_NEGATE"),
    CPUI_INT_XOR("INT_XOR"),
    CPUI_INT_AND("INT_AND"),
    CPUI_INT_OR("INT_OR"),
    CPUI_INT_LEFT("INT_LEFT"),
    CPUI_INT_RIGHT("INT_RIGHT"),
    CPUI_INT_SRIGHT("INT_SRIGHT"),
    CPUI_INT_MULT("INT_MULT"),
    CPUI_INT_DIV("INT_DIV"),
    CPUI_INT_SDIV("INT_SDIV"),
    CPUI_INT_REM("INT_REM"),
    CPUI_INT_SREM("INT_SREM"),
    CPUI_BOOL_NEGATE("BOOL_NEGATE"),
    CPUI_BOOL_XOR("BOOL_XOR"),
    CPUI_BOOL_AND("BOOL_AND"),
    CPUI_BOOL_OR("BOOL_OR"),
    CPUI_FLOAT_EQUAL("FLOAT_EQUAL"),
    CPUI_FLOAT_NOTEQUAL("FLOAT_NOTEQUAL"),
    CPUI_FLOAT_LESS("FLOAT_LESS"),
    CPUI_FLOAT_LESSEQUAL("FLOAT_LESSEQUAL"),
    CPUI_UNUSED1("UNUSED1"),
    CPUI_FLOAT_NAN("FLOAT_NAN"),
    CPUI_FLOAT_ADD("FLOAT_ADD"),
    CPUI_FLOAT_DIV("FLOAT_DIV"),
    CPUI_FLOAT_MULT("FLOAT_MULT"),
    CPUI_FLOAT_SUB("FLOAT_SUB"),
    CPUI_FLOAT_NEG("FLOAT_NEG"),
    CPUI_FLOAT_ABS("FLOAT_ABS"),
    CPUI_FLOAT_SQRT("FLOAT_SQRT"),
    CPUI_FLOAT_INT2FLOAT("INT2FLOAT"),
    CPUI_FLOAT_FLOAT2FLOAT("FLOAT2FLOAT"),
    CPUI_FLOAT_TRUNC("TRUNC"),
    CPUI_FLOAT_CEIL("CEIL"),
    CPUI_FLOAT_FLOOR("FLOOR"),
    CPUI_FLOAT_ROUND("ROUND"),
    CPUI_MULTIEQUAL("BUILD"),
    CPUI_INDIRECT("DELAY_SLOT"),
    CPUI_PIECE("PIECE"),
    CPUI_SUBPIECE("SUBPIECE"),
    CPUI_CAST("CAST"),
    CPUI_PTRADD("LABEL"),
    CPUI_PTRSUB("CROSSBUILD"),
    CPUI_SEGMENTOP("SEGMENTOP"),
    CPUI_CPOOLREF("CPOOLREF"),
    CPUI_NEW("NEW"),
    CPUI_INSERT("INSERT"),
    CPUI_EXTRACT("EXTRACT"),
    CPUI_POPCOUNT("POPCOUNT"),
    CPUI_LZCOUNT("LZCOUNT"),
    CPUI_MAX(null);

    private final String name;
    static final List<OpCode> opsByOrdinal;
    static final Map<String, OpCode> opsByName;

    private OpCode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public OpCode getOpCodeFlip() {
        return switch (this.ordinal()) {
            case 11 -> CPUI_INT_NOTEQUAL;
            case 12 -> CPUI_INT_EQUAL;
            case 13 -> CPUI_INT_SLESSEQUAL;
            case 14 -> CPUI_INT_SLESS;
            case 15 -> CPUI_INT_LESSEQUAL;
            case 16 -> CPUI_INT_LESS;
            case 37 -> CPUI_COPY;
            case 41 -> CPUI_FLOAT_NOTEQUAL;
            case 42 -> CPUI_FLOAT_EQUAL;
            case 43 -> CPUI_FLOAT_LESSEQUAL;
            case 44 -> CPUI_FLOAT_LESS;
            default -> CPUI_MAX;
        };
    }

    public boolean getBooleanFlip() {
        return switch (this.ordinal()) {
            case 11 -> false;
            case 12 -> false;
            case 13 -> true;
            case 14 -> true;
            case 15 -> true;
            case 16 -> true;
            case 37 -> false;
            case 41 -> false;
            case 42 -> false;
            case 43 -> true;
            case 44 -> true;
            default -> false;
        };
    }

    public static OpCode getOpcode(int ordinal) {
        return opsByOrdinal.get(ordinal);
    }

    public static OpCode getOpcode(String nm) {
        return opsByName.get(nm);
    }

    static {
        opsByOrdinal = List.of(OpCode.values());
        opsByName = Stream.of(OpCode.values()).filter(op -> op != DO_NOT_USE_ME_I_AM_ENUM_ELEMENT_ZERO && op != CPUI_MAX).collect(Collectors.toUnmodifiableMap(OpCode::getName, op -> op));
    }
}

