/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PcodeBlock;
import java.io.IOException;

public class BlockCopy
extends PcodeBlock {
    private Object ref;
    private Address address;
    private int altindex;

    public BlockCopy() {
        this.blocktype = 3;
        this.address = Address.NO_ADDRESS;
        this.ref = null;
    }

    public BlockCopy(Object r, Address addr) {
        this.ref = r;
        this.blocktype = 3;
        this.address = addr;
    }

    @Override
    public Address getStart() {
        return this.address;
    }

    @Override
    public Address getStop() {
        return this.address;
    }

    public Object getRef() {
        return this.ref;
    }

    protected void set(Object r, Address addr) {
        this.ref = r;
        this.address = addr;
    }

    public int getAltIndex() {
        return this.altindex;
    }

    @Override
    protected void encodeHeader(Encoder encoder) throws IOException {
        super.encodeHeader(encoder);
        encoder.writeSignedInteger(AttributeId.ATTRIB_ALTINDEX, this.altindex);
    }

    @Override
    protected void decodeHeader(Decoder decoder) throws DecoderException {
        super.decodeHeader(decoder);
        this.altindex = (int)decoder.readSignedInteger(AttributeId.ATTRIB_ALTINDEX);
    }
}

