/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.attribs;

import ghidra.app.util.bin.InvalidDataException;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeClass;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeDef;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeValue;
import ghidra.program.model.scalar.Scalar;
import java.io.IOException;

public class DWARFNumericAttribute
extends DWARFAttributeValue {
    private final Scalar value;
    private final boolean ambiguous;

    public DWARFNumericAttribute(long value, DWARFAttributeDef<?> def) {
        this(64, value, true, false, def);
    }

    public DWARFNumericAttribute(int bitLength, long value, boolean signed, DWARFAttributeDef<?> def) {
        this(bitLength, value, signed, false, def);
    }

    public DWARFNumericAttribute(int bitLength, long value, boolean signed, boolean ambiguous, DWARFAttributeDef<?> def) {
        super(def);
        this.value = new Scalar(bitLength, value, signed);
        this.ambiguous = ambiguous;
    }

    public boolean isAmbiguousSignedness() {
        return this.ambiguous;
    }

    public long getValueWithSignednessHint(boolean signednessHint) {
        return this.value.getValue(this.ambiguous ? signednessHint : this.value.isSigned());
    }

    public boolean isHighbitSet() {
        return this.value.bitLength() > 0 ? this.value.testBit(this.value.bitLength() - 1) : false;
    }

    public long getValue() {
        return this.value.getValue();
    }

    @Override
    public String getValueString(DWARFCompilationUnit cu) {
        long v = this.getValue();
        return "%d [0x%x]".formatted(v, v);
    }

    public long getUnsignedValue() {
        return this.value.getUnsignedValue();
    }

    public int getUnsignedIntExact() throws IOException {
        long x = this.value.getUnsignedValue();
        if (x < 0L || Integer.MAX_VALUE < x) {
            throw new InvalidDataException("Value out of range for positive java 32 bit unsigned int: %d [0x%d]".formatted(x, x));
        }
        return (int)x;
    }

    public String toElementLocationString(String elementType, String sectionName, int index, long offset, int ver) {
        String indexStr = index >= 0 ? " (idx %d)".formatted(index) : "";
        return "%s : %s, %s v%d %s:%x%s".formatted(new Object[]{this.getAttributeName(), this.getAttributeForm(), elementType, ver, sectionName, offset, indexStr});
    }

    @Override
    public String toString(DWARFCompilationUnit cu) {
        short ver = cu.getDWARFVersion();
        if (this.getAttributeForm().isClass(DWARFAttributeClass.address)) {
            return "%s : %s, addr v%d 0x%x".formatted(new Object[]{this.getAttributeName(), this.getAttributeForm(), ver, this.getUnsignedValue()});
        }
        if (this.getAttributeForm().isClass(DWARFAttributeClass.rnglist)) {
            String sectionName = ver < 5 ? "debug_ranges" : "debug_rnglists";
            return this.toElementLocationString("rnglist", sectionName, -1, this.getUnsignedValue(), cu.getDWARFVersion()) + " offset: " + this.getUnsignedValue();
        }
        if (this.getAttributeForm().isClass(DWARFAttributeClass.loclist)) {
            String sectionName = ver < 5 ? "debug_loc" : "debug_loclists";
            return this.toElementLocationString("loclist", sectionName, -1, this.getUnsignedValue(), cu.getDWARFVersion());
        }
        return this.toString();
    }

    public String toString() {
        String orStr = this.ambiguous && this.isHighbitSet() ? " or " + this.value.getValue(!this.value.isSigned()) : "";
        return "%s : %s = %d%s [%s]".formatted(new Object[]{this.getAttributeName(), this.getAttributeForm(), this.getValue(), orStr, this.value.toString(16, true, false, "", "")});
    }
}

