/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class FileSetEntryCommand
extends LoadCommand {
    private long vmaddr;
    private long fileoff;
    private LoadCommandString entryId;
    private int reserved;

    FileSetEntryCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.vmaddr = reader.readNextLong();
        this.fileoff = reader.readNextLong();
        this.entryId = new LoadCommandString(reader, this);
        this.reserved = reader.readNextInt();
    }

    public long getVMaddress() {
        return this.vmaddr;
    }

    public long getFileOffset() {
        return this.fileoff;
    }

    public LoadCommandString getFileSetEntryId() {
        return this.entryId;
    }

    public int getReserved() {
        return this.reserved;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(QWORD, "vmaddr", null);
        struct.add(QWORD, "fileoff", null);
        struct.add(this.entryId.toDataType(), "entry_id", null);
        struct.add(DWORD, "reserved", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "fileset_entry_command";
    }

    public String toString() {
        return this.entryId.getString();
    }
}

