/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableAssemblyRefProcessor
extends CliAbstractTable {
    public CliTableAssemblyRefProcessor(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliAssemblyRefProcessorRow(reader.readNextInt(), this.readTableIndex(reader, CliTypeTable.AssemblyRef)));
        }
    }

    @Override
    public DataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "AssemblyRefProcessor Row", 0);
        rowDt.add(DWORD, "Processor", null);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.AssemblyRef), "AssemblyRef", "index into AssemblyRef table");
        return rowDt;
    }

    public class CliAssemblyRefProcessorRow
    extends CliAbstractTableRow {
        public int processor;
        public int assemblyRefIndex;

        public CliAssemblyRefProcessorRow(int processor, int assemblyRefIndex) {
            this.processor = processor;
            this.assemblyRefIndex = assemblyRefIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("Processor %d AssemblyRef: %s", this.processor, CliTableAssemblyRefProcessor.this.getRowRepresentationSafe(CliTypeTable.AssemblyRef, this.assemblyRefIndex));
        }
    }
}

