/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.app.services.ProgramManager;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;

public class GhidraProgramUtilities {
    private GhidraProgramUtilities() {
    }

    public static Program getCurrentProgram(PluginTool tool) {
        ProgramManager pmService = (ProgramManager)tool.getService(ProgramManager.class);
        return pmService == null ? null : pmService.getCurrentProgram();
    }

    public static boolean shouldAskToAnalyze(Program program) {
        if (program == null || !program.canSave()) {
            return false;
        }
        Options options = program.getOptions("Program Information");
        boolean isAnalyzed = options.getBoolean("Analyzed", false);
        if (isAnalyzed) {
            return false;
        }
        return options.getBoolean("Should Ask To Analyze", true);
    }

    public static void resetAnalysisFlags(Program program) {
        int transactionID = program.startTransaction("Reset Analysis Flags");
        try {
            Options options = program.getOptions("Program Information");
            options.removeOption("Analyzed");
            options.removeOption("Should Ask To Analyze");
        }
        finally {
            program.endTransaction(transactionID, true);
        }
    }

    public static void markProgramAnalyzed(Program program) {
        Options options = program.getOptions("Program Information");
        int transactionID = program.startTransaction("Mark Program Analyzed");
        try {
            options.setBoolean("Analyzed", true);
            options.setBoolean("Should Ask To Analyze", false);
        }
        finally {
            program.endTransaction(transactionID, true);
        }
    }

    public static void markProgramNotToAskToAnalyze(Program program) {
        Options options = program.getOptions("Program Information");
        int transactionID = program.startTransaction("Mark Program To Not Ask To Analyze");
        try {
            options.setBoolean("Should Ask To Analyze", false);
        }
        finally {
            program.endTransaction(transactionID, true);
        }
    }

    public static boolean isAnalyzed(Program program) {
        Options options = program.getOptions("Program Information");
        return options.getBoolean("Analyzed", false);
    }
}

