/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.columnfilter;

import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.columnfilter.LogicOperation;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.MappedColumnConstraint;
import docking.widgets.table.constraint.TableFilterContext;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.framework.options.SaveState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class ColumnConstraintSet<R, T> {
    private final List<ColumnConstraint<T>> constraints = new ArrayList<ColumnConstraint<T>>();
    private final int columnIndex;
    private final RowObjectTableModel<R> model;
    private final LogicOperation logicOperation;

    public ColumnConstraintSet(RowObjectTableModel<R> model, int columnIndex, List<ColumnConstraint<T>> constraints, LogicOperation logicOperation) {
        this.model = model;
        this.columnIndex = columnIndex;
        this.logicOperation = logicOperation;
        this.constraints.addAll(constraints);
    }

    public ColumnConstraintSet(RowObjectTableModel<R> model, SaveState saveState, Object dataSource) {
        String columnName = saveState.getString("COLUMN_NAME", null);
        int constraintCount = saveState.getInt("CONSTRAINT_COUNT", 0);
        this.columnIndex = saveState.getInt("COLUMN_MODEL_INDEX", -1);
        this.logicOperation = LogicOperation.valueOf(saveState.getString("LOGICAL_OP", "AND"));
        if (!model.getColumnName(this.columnIndex).equals(columnName)) {
            throw new IllegalArgumentException("ColumnFilter does not match table model");
        }
        this.model = model;
        for (int i = 0; i < constraintCount; ++i) {
            String constraintName = saveState.getString("CONSTRAINT_NAME_" + i, null);
            String valueString = saveState.getString("CONSTRAINT_VALUE_" + i, null);
            this.constraints.add(this.findColumnConstraint(constraintName, valueString, dataSource));
        }
    }

    private ColumnConstraint<T> findColumnConstraint(String constraintName, String value, Object dataSource) {
        Class<?> columnClass = this.model.getColumnClass(this.columnIndex);
        Collection<ColumnConstraint<?>> columnConstraints = DiscoverableTableUtils.getColumnConstraints(columnClass);
        for (ColumnConstraint<?> constraint : columnConstraints) {
            if (!constraint.getName().equals(constraintName)) continue;
            return constraint.parseConstraintValue(value, dataSource);
        }
        throw new IllegalArgumentException("Can't find constraint for " + constraintName + " for value: " + value);
    }

    public String getColumnName() {
        return this.model.getColumnName(this.getColumnModelIndex());
    }

    public int getColumnModelIndex() {
        return this.columnIndex;
    }

    public boolean accepts(R rowObject, TableFilterContext context) {
        Object value = this.model.getColumnValueForRow(rowObject, this.columnIndex);
        for (ColumnConstraint<Object> columnConstraint : this.constraints) {
            if (!columnConstraint.accepts(value, context)) continue;
            return true;
        }
        return false;
    }

    public List<ColumnConstraint<T>> getConstraints() {
        return this.constraints;
    }

    public LogicOperation getLogicOperation() {
        return this.logicOperation;
    }

    SaveState save() {
        SaveState saveState = new SaveState("CONSTRAINT_TABLE_FILTER");
        saveState.putString("COLUMN_NAME", this.model.getColumnName(this.columnIndex));
        saveState.putInt("COLUMN_MODEL_INDEX", this.columnIndex);
        saveState.putInt("CONSTRAINT_COUNT", this.constraints.size());
        saveState.putString("LOGICAL_OP", this.logicOperation.name());
        for (int i = 0; i < this.constraints.size(); ++i) {
            ColumnConstraint<T> constraint = this.constraints.get(i);
            saveState.putString("CONSTRAINT_NAME_" + i, constraint.getName());
            saveState.putString("CONSTRAINT_VALUE_" + i, constraint.getConstraintValueString());
        }
        return saveState;
    }

    String getHtmlRepresentation() {
        StringBuilder buf = new StringBuilder();
        buf.append("<table valign=top cellpadding=0 cellspacing=0>");
        buf.append("<tr><td style=\"font-weight:bold\">");
        buf.append(this.model.getColumnName(this.columnIndex));
        buf.append("&nbsp;");
        buf.append("</td>");
        buf.append("<td>");
        buf.append(this.getHtmlRepresentation(this.constraints.get(0)));
        buf.append("<td></tr>");
        GColor gray = GThemeDefaults.Colors.Palette.GRAY;
        String grayHex = gray.toHexString();
        for (int i = 1; i < this.constraints.size(); ++i) {
            buf.append("<tr><td style=\"color:").append(grayHex);
            buf.append("; text-align:center\">or</td>");
            buf.append("<td >");
            buf.append(this.getHtmlRepresentation(this.constraints.get(i)));
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }

    private String getHtmlRepresentation(ColumnConstraint<?> columnConstraint) {
        StringBuilder buf = new StringBuilder();
        buf.append(columnConstraint.getName());
        boolean quoteValue = ColumnConstraintSet.isStringBasedConstraint(columnConstraint);
        buf.append(" ");
        if (quoteValue) {
            buf.append("\"");
        }
        buf.append("<span style=\"font-weight:bold\">");
        buf.append(columnConstraint.getConstraintValueString());
        buf.append("</span>");
        if (quoteValue) {
            buf.append("\"");
        }
        buf.append(" ");
        return buf.toString();
    }

    private static boolean isStringBasedConstraint(ColumnConstraint<?> constraint) {
        if (constraint instanceof MappedColumnConstraint) {
            constraint = ((MappedColumnConstraint)constraint).getDelegate();
            return ColumnConstraintSet.isStringBasedConstraint(constraint);
        }
        return constraint.getColumnType().equals(String.class);
    }

    public int hashCode() {
        return Objects.hash(this.model.getClass(), this.columnIndex, this.constraints);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnConstraintSet other = (ColumnConstraintSet)obj;
        if (this.logicOperation != other.logicOperation) {
            return false;
        }
        if (this.columnIndex != other.columnIndex) {
            return false;
        }
        if (this.model != other.model) {
            return false;
        }
        return Objects.equals(this.constraints, other.constraints);
    }

    public String toString() {
        return "{\n\tcolumn: " + this.columnIndex + ",\n\toperation: " + String.valueOf((Object)this.logicOperation) + ",\n\tconstraints: " + String.valueOf(CollectionUtils.collect(this.constraints, c -> c.asString())) + "\n}";
    }
}

