/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.tree.GTreeNode;
import java.util.List;

public abstract class GTreeLazyNode
extends GTreeNode {
    @Override
    protected abstract List<GTreeNode> generateChildren();

    public void unloadChildren() {
        if (this.isLoaded()) {
            this.setChildren(null);
        }
    }

    @Override
    public void addNode(GTreeNode node) {
        if (this.isLoaded()) {
            super.addNode(node);
        }
    }

    @Override
    public void addNode(int index, GTreeNode node) {
        if (this.isLoaded()) {
            super.addNode(index, node);
        }
    }

    @Override
    public void addNodes(List<GTreeNode> nodes) {
        if (this.isLoaded()) {
            super.addNodes(nodes);
        }
    }

    @Override
    public void removeAll() {
        this.unloadChildren();
    }

    @Override
    public void removeNode(GTreeNode node) {
        if (!this.isLoaded()) {
            return;
        }
        super.removeNode(node);
    }
}

