import { __exports as markup } from '../../../../../../../../_virtual/markup.js';
import { __require as requireEscapeHTML } from './escapeHTML.js';

var hasRequiredMarkup;

function requireMarkup () {
	if (hasRequiredMarkup) return markup;
	hasRequiredMarkup = 1;

	Object.defineProperty(markup, '__esModule', {
	  value: true
	});
	markup.printText =
	  markup.printProps =
	  markup.printElementAsLeaf =
	  markup.printElement =
	  markup.printComment =
	  markup.printChildren =
	    undefined;

	var _escapeHTML = _interopRequireDefault(requireEscapeHTML());

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : {default: obj};
	}

	/**
	 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
	 *
	 * This source code is licensed under the MIT license found in the
	 * LICENSE file in the root directory of this source tree.
	 */
	// Return empty string if keys is empty.
	const printProps = (keys, props, config, indentation, depth, refs, printer) => {
	  const indentationNext = indentation + config.indent;
	  const colors = config.colors;
	  return keys
	    .map(key => {
	      const value = props[key];
	      let printed = printer(value, config, indentationNext, depth, refs);

	      if (typeof value !== 'string') {
	        if (printed.indexOf('\n') !== -1) {
	          printed =
	            config.spacingOuter +
	            indentationNext +
	            printed +
	            config.spacingOuter +
	            indentation;
	        }

	        printed = '{' + printed + '}';
	      }

	      return (
	        config.spacingInner +
	        indentation +
	        colors.prop.open +
	        key +
	        colors.prop.close +
	        '=' +
	        colors.value.open +
	        printed +
	        colors.value.close
	      );
	    })
	    .join('');
	}; // Return empty string if children is empty.

	markup.printProps = printProps;

	const printChildren = (children, config, indentation, depth, refs, printer) =>
	  children
	    .map(
	      child =>
	        config.spacingOuter +
	        indentation +
	        (typeof child === 'string'
	          ? printText(child, config)
	          : printer(child, config, indentation, depth, refs))
	    )
	    .join('');

	markup.printChildren = printChildren;

	const printText = (text, config) => {
	  const contentColor = config.colors.content;
	  return (
	    contentColor.open + (0, _escapeHTML.default)(text) + contentColor.close
	  );
	};

	markup.printText = printText;

	const printComment = (comment, config) => {
	  const commentColor = config.colors.comment;
	  return (
	    commentColor.open +
	    '<!--' +
	    (0, _escapeHTML.default)(comment) +
	    '-->' +
	    commentColor.close
	  );
	}; // Separate the functions to format props, children, and element,
	// so a plugin could override a particular function, if needed.
	// Too bad, so sad: the traditional (but unnecessary) space
	// in a self-closing tagColor requires a second test of printedProps.

	markup.printComment = printComment;

	const printElement = (
	  type,
	  printedProps,
	  printedChildren,
	  config,
	  indentation
	) => {
	  const tagColor = config.colors.tag;
	  return (
	    tagColor.open +
	    '<' +
	    type +
	    (printedProps &&
	      tagColor.close +
	        printedProps +
	        config.spacingOuter +
	        indentation +
	        tagColor.open) +
	    (printedChildren
	      ? '>' +
	        tagColor.close +
	        printedChildren +
	        config.spacingOuter +
	        indentation +
	        tagColor.open +
	        '</' +
	        type
	      : (printedProps && !config.min ? '' : ' ') + '/') +
	    '>' +
	    tagColor.close
	  );
	};

	markup.printElement = printElement;

	const printElementAsLeaf = (type, config) => {
	  const tagColor = config.colors.tag;
	  return (
	    tagColor.open +
	    '<' +
	    type +
	    tagColor.close +
	    ' …' +
	    tagColor.open +
	    ' />' +
	    tagColor.close
	  );
	};

	markup.printElementAsLeaf = printElementAsLeaf;
	return markup;
}

export { requireMarkup as __require };
//# sourceMappingURL=markup.js.map
