/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution.run;

import com.intellij.openapi.project.Project;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.project.BundledMaven;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenHomeType;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/execution/run/MavenRuntimeTargetResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "eel", "Lcom/intellij/platform/eel/EelApi;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/eel/EelApi;)V", "resolve", "Lorg/jetbrains/idea/maven/execution/target/MavenRuntimeTargetConfiguration;", "configuration", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "isBundledMavenRequired", "", "intellij.maven"})
public final class MavenRuntimeTargetResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final EelApi eel;

    public MavenRuntimeTargetResolver(@NotNull Project project, @NotNull EelApi eel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
        this.project = project;
        this.eel = eel;
    }

    @NotNull
    public final MavenRuntimeTargetConfiguration resolve(@NotNull MavenRunConfiguration configuration) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        MavenDistributionsCache mavenCache = MavenDistributionsCache.getInstance(this.project);
        String string = configuration.getRunnerParameters().getWorkingDirPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWorkingDirPath(...)");
        String workingDirPath = string;
        MavenDistribution mavenDistribution = mavenCache.getMavenDistribution(workingDirPath);
        Intrinsics.checkNotNullExpressionValue((Object)mavenDistribution, (String)"getMavenDistribution(...)");
        MavenDistribution mavenDistribution2 = mavenDistribution;
        Path it = mavenDistribution2.getMavenHome();
        boolean bl = false;
        if (this.isBundledMavenRequired()) {
            PosixFilePermission[] posixFilePermissionArray = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE};
            path = EelPathUtils.transferContentsIfNonLocal((EelApi)this.eel, (Path)it, null, (EelPathUtils.FileTransferAttributesStrategy)((EelPathUtils.FileTransferAttributesStrategy)EelPathUtils.FileTransferAttributesStrategy.Companion.copyWithRequiredPosixPermissions(posixFilePermissionArray)));
        } else {
            path = it;
        }
        Path mavenHomePath = path;
        String effectiveMavenHome = EelNioBridgeServiceKt.asEelPath((Path)mavenHomePath).toString();
        String string2 = mavenDistribution2.getVersion();
        if (string2 == null) {
            string2 = "";
        }
        String mavenVersion = string2;
        MavenRuntimeTargetConfiguration mavenConfig = new MavenRuntimeTargetConfiguration();
        mavenConfig.setHomePath(effectiveMavenHome);
        mavenConfig.setVersionString(mavenVersion);
        return mavenConfig;
    }

    private final boolean isBundledMavenRequired() {
        MavenGeneralSettings settings = MavenProjectsManager.getInstance(this.project).getGeneralSettings();
        MavenHomeType mavenHomeType = settings.getMavenHomeType();
        Intrinsics.checkNotNullExpressionValue((Object)mavenHomeType, (String)"getMavenHomeType(...)");
        MavenHomeType homeType = mavenHomeType;
        return homeType instanceof BundledMaven;
    }
}

