/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.resourceFilterModel;

import com.google.gson.GsonBuilder;
import com.intellij.util.ReflectionUtilRt;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ContentFilterable;
import org.gradle.api.internal.file.copy.RegExpNameMapper;
import org.gradle.api.internal.file.copy.RenamingCopyAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalFilter;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0006H\u0007J&\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u000e2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J=\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001a2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u001c\"\u00020\u0006\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/gradle/toolingExtension/impl/model/resourceFilterModel/GradleResourceFilterModelBuilder;", "", "<init>", "()V", "getIncludes", "", "", "project", "Lorg/gradle/api/Project;", "taskName", "getExcludes", "", "getFilters", "", "Lorg/jetbrains/plugins/gradle/model/DefaultExternalFilter;", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "getFilter", "action", "Lorg/gradle/api/Action;", "getCommonFilter", "getRenamingCopyFilter", "findPropertyWithType", "T", "self", "type", "Ljava/lang/Class;", "propertyNames", "", "(Ljava/lang/Object;Ljava/lang/Class;[Ljava/lang/String;)Ljava/lang/Object;", "intellij.gradle.toolingExtension.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGradleResourceFilterModelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleResourceFilterModelBuilder.kt\ncom/intellij/gradle/toolingExtension/impl/model/resourceFilterModel/GradleResourceFilterModelBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
public final class GradleResourceFilterModelBuilder {
    @NotNull
    public static final GradleResourceFilterModelBuilder INSTANCE = new GradleResourceFilterModelBuilder();

    private GradleResourceFilterModelBuilder() {
    }

    @JvmStatic
    @NotNull
    public static final Set<String> getIncludes(@NotNull Project project, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Task filterableTask = (Task)project.getTasks().findByName(taskName);
        if (filterableTask instanceof PatternFilterable) {
            Set set = ((PatternFilterable)filterableTask).getIncludes();
            Intrinsics.checkNotNull((Object)set, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.String?>");
            return TypeIntrinsics.asMutableSet((Object)set);
        }
        return new LinkedHashSet();
    }

    @JvmStatic
    @NotNull
    public static final Set<String> getExcludes(@NotNull Project project, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Task filterableTask = (Task)project.getTasks().findByName(taskName);
        if (filterableTask instanceof PatternFilterable) {
            Set set = ((PatternFilterable)filterableTask).getExcludes();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getExcludes(...)");
            return set;
        }
        return new LinkedHashSet();
    }

    @JvmStatic
    @NotNull
    public static final List<DefaultExternalFilter> getFilters(@NotNull Project project, @NotNull ModelBuilderContext context, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        ArrayList<DefaultExternalFilter> filterReaders = new ArrayList<DefaultExternalFilter>();
        if (Boolean.parseBoolean(System.getProperty("idea.disable.gradle.resource.filtering"))) {
            return filterReaders;
        }
        Task filterableTask = (Task)project.getTasks().findByName(taskName);
        if (filterableTask instanceof ContentFilterable && !DefaultGroovyMethods.getMetaClass((Object)filterableTask).respondsTo((Object)filterableTask, "getMainSpec").isEmpty()) {
            Object mainSpec = DefaultGroovyMethods.invokeMethod((Object)filterableTask, (String)"getMainSpec", (Object)new Object[0]);
            if (mainSpec == null) {
                return filterReaders;
            }
            Object copyActions = null;
            MetaProperty metaProperty = DefaultGroovyMethods.hasProperty((Object)mainSpec, (String)"allCopyActions");
            if (metaProperty == null && (metaProperty = DefaultGroovyMethods.hasProperty((Object)mainSpec, (String)"copyActions")) == null) {
                return filterReaders;
            }
            MetaProperty property = metaProperty;
            Object object = property.getProperty(mainSpec);
            if (object == null) {
                return filterReaders;
            }
            copyActions = object;
            if (copyActions instanceof Iterable) {
                for (Object action : (Iterable)copyActions) {
                    DefaultExternalFilter filter;
                    if (!(action instanceof Action) || (filter = INSTANCE.getFilter(project, context, (Action)action)) == null) continue;
                    filterReaders.add(filter);
                }
            }
        }
        return filterReaders;
    }

    private final DefaultExternalFilter getFilter(Project project, ModelBuilderContext context, Action<?> action) {
        try {
            if (Intrinsics.areEqual((Object)"RenamingCopyAction", (Object)action.getClass().getSimpleName())) {
                return this.getRenamingCopyFilter(action);
            }
            return this.getCommonFilter(action);
        }
        catch (Exception exception) {
            context.getMessageReporter().createMessage().withGroup("gradle.resourceModel.group").withTitle("Resource configuration warning").withText(StringsKt.trimMargin$default((String)("\n          | Cannot resolve resource filtering of " + action.getClass().getSimpleName() + ".\n          | IDEA may fail to build project. Consider using delegated build (enabled by default).\n          | "), null, (int)1, null)).withKind(Message.Kind.WARNING).reportMessage(project);
            return null;
        }
    }

    private final DefaultExternalFilter getCommonFilter(Action<?> action) {
        String[] stringArray = new String[]{"filterType", "val$filterType", "arg$2", "arg$1"};
        Class filterClass = this.findPropertyWithType(action, Class.class, stringArray);
        if (filterClass == null) {
            boolean $i$a$-requireNotNull-GradleResourceFilterModelBuilder$getCommonFilter$22 = false;
            String $i$a$-requireNotNull-GradleResourceFilterModelBuilder$getCommonFilter$22 = "Unsupported action found: " + action.getClass().getName();
            throw new IllegalArgumentException($i$a$-requireNotNull-GradleResourceFilterModelBuilder$getCommonFilter$22.toString());
        }
        String filterType = filterClass.getName();
        String[] stringArray2 = new String[]{"properties", "val$properties", "arg$1"};
        Map properties = this.findPropertyWithType(action, Map.class, stringArray2);
        if (Intrinsics.areEqual((Object)"org.apache.tools.ant.filters.ExpandProperties", (Object)filterType) && properties != null && properties.get("project") != null) {
            Object project = properties.get("project");
            properties = (Map)DefaultGroovyMethods.invokeMethod(project, (String)"getProperties", (Object)new Object[0]);
        }
        DefaultExternalFilter filter = new DefaultExternalFilter();
        filter.setFilterType(filterType);
        if (properties != null) {
            filter.setPropertiesAsJsonMap(new GsonBuilder().create().toJson((Object)properties));
        }
        return filter;
    }

    private final DefaultExternalFilter getRenamingCopyFilter(Action<?> action) {
        String pattern;
        boolean bl = Intrinsics.areEqual((Object)"RenamingCopyAction", (Object)action.getClass().getSimpleName());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object transformerObject = ReflectionUtilRt.getField(RenamingCopyAction.class, action, null, (String)"transformer");
        if (!(transformerObject instanceof RegExpNameMapper)) {
            return null;
        }
        Object transformer = transformerObject;
        Object object = (Matcher)ReflectionUtilRt.getField(RegExpNameMapper.class, (Object)transformer, Matcher.class, (String)"matcher");
        String string = object != null && (object = ((Matcher)object).pattern()) != null ? ((Pattern)object).pattern() : (pattern = null);
        if (pattern == null) {
            Pattern pattern2 = (Pattern)ReflectionUtilRt.getField(RegExpNameMapper.class, (Object)transformer, Pattern.class, (String)"pattern");
            pattern = pattern2 != null ? pattern2.pattern() : null;
        }
        String replacement = (String)ReflectionUtilRt.getField(RegExpNameMapper.class, (Object)transformer, String.class, (String)"replacement");
        DefaultExternalFilter filter = new DefaultExternalFilter();
        filter.setFilterType("RenamingCopyFilter");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(2);
        map.put("pattern", pattern);
        map.put("replacement", replacement);
        filter.setPropertiesAsJsonMap(new GsonBuilder().create().toJson(map));
        return filter;
    }

    @Nullable
    public final <T> T findPropertyWithType(@NotNull Object self, @NotNull Class<T> type, String ... propertyNames) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)propertyNames, (String)"propertyNames");
        for (String name : propertyNames) {
            try {
                Field field = self.getClass().getDeclaredField(name);
                if (!type.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                return (T)field.get(self);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }
}

