/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.highlighting;

import com.intellij.lexer.StringLiteralLexer;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JsonStringLiteralLexer
extends StringLiteralLexer {
    private static final String PERMISSIVE_ESCAPES;
    private final boolean myIsPermissiveDialect;

    public JsonStringLiteralLexer(char quoteChar, IElementType originalLiteralToken, boolean canEscapeEol, boolean isPermissiveDialect) {
        super(quoteChar, originalLiteralToken, canEscapeEol, isPermissiveDialect ? PERMISSIVE_ESCAPES : "/", false, isPermissiveDialect);
        this.myIsPermissiveDialect = isPermissiveDialect;
    }

    @NotNull
    protected IElementType handleSingleSlashEscapeSequence() {
        IElementType iElementType = this.myIsPermissiveDialect ? this.myOriginalLiteralToken : super.handleSingleSlashEscapeSequence();
        if (iElementType == null) {
            JsonStringLiteralLexer.$$$reportNull$$$0(0);
        }
        return iElementType;
    }

    protected boolean shouldAllowSlashZero() {
        return this.myIsPermissiveDialect;
    }

    static {
        StringBuilder escapesBuilder = new StringBuilder("/");
        for (char c = '\u0001'; c < '\u00ad'; c = (char)(c + 1)) {
            if (c == 120 || c == 117 || Character.isDigit(c) || c == 10 || c == 13) continue;
            escapesBuilder.append(c);
        }
        PERMISSIVE_ESCAPES = escapesBuilder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/highlighting/JsonStringLiteralLexer", "handleSingleSlashEscapeSequence"));
    }
}

