/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightInfoTypeSemanticNames;
import org.jetbrains.kotlin.idea.highlighter.visitor.AbstractHighlightingVisitor;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/BeforeResolveHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/visitor/AbstractHighlightingVisitor;", "Lcom/intellij/openapi/project/DumbAware;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "<init>", "(Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;)V", "visitElement", "", "element", "Lcom/intellij/psi/PsiElement;", "willApplyRainbowHighlight", "", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocLink;", "visitLambdaExpression", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "visitArgument", "argument", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "visitExpressionWithLabel", "expression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "visitSuperTypeCallEntry", "call", "Lorg/jetbrains/kotlin/psi/KtSuperTypeCallEntry;", "visitTypeParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "intellij.kotlin.highlighting.minimal"})
@SourceDebugExtension(value={"SMAP\nBeforeResolveHighlightingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeforeResolveHighlightingVisitor.kt\norg/jetbrains/kotlin/idea/highlighter/BeforeResolveHighlightingVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class BeforeResolveHighlightingVisitor
extends AbstractHighlightingVisitor
implements DumbAware {
    public BeforeResolveHighlightingVisitor(@NotNull HighlightInfoHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super(holder);
    }

    public void visitElement(@NotNull PsiElement element) {
        HighlightInfoType highlightInfoType;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IElementType iElementType = element.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType elementType = iElementType;
        if (element instanceof KDocLink && !this.willApplyRainbowHighlight((KDocLink)element)) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getKDOC_LINK();
        } else if (KtTokens.SOFT_KEYWORDS.contains(elementType)) {
            IElementType iElementType2 = elementType;
            highlightInfoType = KtTokens.MODIFIER_KEYWORDS.contains(iElementType2) ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getBUILTIN_ANNOTATION() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getKEYWORD();
        } else if (Intrinsics.areEqual((Object)elementType, (Object)KtTokens.ALL_KEYWORD)) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getKEYWORD();
        } else if (Intrinsics.areEqual((Object)elementType, (Object)KtTokens.SAFE_ACCESS)) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getSAFE_ACCESS();
        } else if (Intrinsics.areEqual((Object)elementType, (Object)KtTokens.EXCLEXCL)) {
            highlightInfoType = KotlinHighlightInfoTypeSemanticNames.INSTANCE.getEXCLEXCL();
        } else {
            return;
        }
        HighlightInfoType attributes = highlightInfoType;
        AbstractHighlightingVisitor.highlightName$default(this, element, attributes, null, 4, null);
    }

    private final boolean willApplyRainbowHighlight(KDocLink element) {
        if (!RainbowHighlighter.isRainbowEnabledWithInheritance((TextAttributesScheme)((TextAttributesScheme)EditorColorsManager.getInstance().getGlobalScheme()), (Language)((Language)KotlinLanguage.INSTANCE))) {
            return false;
        }
        PsiElement psiElement = element.getParent();
        KDocTag kDocTag = psiElement instanceof KDocTag ? (KDocTag)psiElement : null;
        return (kDocTag != null ? kDocTag.getKnownTag() : null) == KDocKnownTag.PARAM;
    }

    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        PsiElement arrow;
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        KtFunctionLiteral ktFunctionLiteral = lambdaExpression.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
        KtFunctionLiteral functionLiteral = ktFunctionLiteral;
        AbstractHighlightingVisitor abstractHighlightingVisitor = this;
        PsiElement psiElement = functionLiteral.getLBrace();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getLBrace(...)");
        AbstractHighlightingVisitor.highlightName$default(abstractHighlightingVisitor, psiElement, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_LITERAL_BRACES_AND_ARROW(), null, 4, null);
        PsiElement closingBrace = functionLiteral.getRBrace();
        if (closingBrace != null) {
            AbstractHighlightingVisitor.highlightName$default(this, closingBrace, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_LITERAL_BRACES_AND_ARROW(), null, 4, null);
        }
        if ((arrow = functionLiteral.getArrow()) != null) {
            AbstractHighlightingVisitor.highlightName$default(this, arrow, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_LITERAL_BRACES_AND_ARROW(), null, 4, null);
        }
    }

    public void visitArgument(@NotNull KtValueArgument argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        KtValueArgumentName ktValueArgumentName = argument.getArgumentName();
        if (ktValueArgumentName == null) {
            return;
        }
        KtValueArgumentName argumentName = ktValueArgumentName;
        PsiElement psiElement = argument.getEqualsToken();
        if (psiElement == null) {
            return;
        }
        PsiElement eq = psiElement;
        PsiElement parent = argument.getParent();
        AbstractHighlightingVisitor abstractHighlightingVisitor = this;
        Project project = argument.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AbstractHighlightingVisitor.highlightName$default(abstractHighlightingVisitor, project, (PsiElement)argument, new TextRange(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)argumentName)), PsiUtilsKt.getEndOffset((PsiElement)eq)), parent instanceof KtValueArgumentList && ((KtValueArgumentList)parent).getParent() instanceof KtAnnotationEntry ? KotlinHighlightInfoTypeSemanticNames.INSTANCE.getANNOTATION_ATTRIBUTE_NAME_ATTRIBUTES() : KotlinHighlightInfoTypeSemanticNames.INSTANCE.getNAMED_ARGUMENT(), null, 16, null);
    }

    public void visitExpressionWithLabel(@NotNull KtExpressionWithLabel expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtSimpleNameExpression targetLabel = expression.getTargetLabel();
        if (targetLabel != null) {
            AbstractHighlightingVisitor.highlightName$default(this, (PsiElement)targetLabel, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getLABEL(), null, 4, null);
        }
    }

    public void visitSuperTypeCallEntry(@NotNull KtSuperTypeCallEntry call) {
        KtTypeElement typeElement;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        KtConstructorCalleeExpression ktConstructorCalleeExpression = call.getCalleeExpression();
        Intrinsics.checkNotNullExpressionValue((Object)ktConstructorCalleeExpression, (String)"getCalleeExpression(...)");
        KtConstructorCalleeExpression calleeExpression = ktConstructorCalleeExpression;
        KtTypeReference ktTypeReference = calleeExpression.getTypeReference();
        Object object = typeElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        if (typeElement instanceof KtUserType) {
            KtSimpleNameExpression ktSimpleNameExpression = ((KtUserType)typeElement).getReferenceExpression();
            if (ktSimpleNameExpression != null) {
                KtSimpleNameExpression it = ktSimpleNameExpression;
                boolean bl = false;
                AbstractHighlightingVisitor.highlightName$default(this, (PsiElement)it, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getCONSTRUCTOR_CALL(), null, 4, null);
            }
        }
        super.visitSuperTypeCallEntry(call);
    }

    public void visitTypeParameter(@NotNull KtTypeParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        PsiElement psiElement = parameter.getNameIdentifier();
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            AbstractHighlightingVisitor.highlightName$default(this, it, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getTYPE_PARAMETER(), null, 4, null);
        }
        super.visitTypeParameter(parameter);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.highlightNamedDeclaration((KtNamedDeclaration)function, KotlinHighlightInfoTypeSemanticNames.INSTANCE.getFUNCTION_DECLARATION());
        super.visitNamedFunction(function);
    }
}

