/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.changes.ui.PseudoSplitter;
import com.intellij.ui.AbstractTitledSeparatorWithIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventHandler;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
abstract class SplitterWithSecondHideable {
    @NotNull
    private final PseudoSplitter mySplitter;
    @NotNull
    private final MyTitledSeparator myTitledSeparator;
    @NotNull
    private final OnOffListener myListener;
    @NotNull
    private final JPanel myFictivePanel;
    private float myPreviousProportion;

    SplitterWithSecondHideable(boolean vertical, @NlsContexts.Separator @NotNull String separatorText, @NotNull JComponent firstComponent, @NotNull OnOffListener listener2) {
        if (separatorText == null) {
            SplitterWithSecondHideable.$$$reportNull$$$0(0);
        }
        if (firstComponent == null) {
            SplitterWithSecondHideable.$$$reportNull$$$0(1);
        }
        if (listener2 == null) {
            SplitterWithSecondHideable.$$$reportNull$$$0(2);
        }
        this.myListener = listener2;
        this.myFictivePanel = JBUI.Panels.simplePanel();
        this.myTitledSeparator = new MyTitledSeparator(separatorText, vertical);
        this.mySplitter = new MySplitter(vertical);
        this.mySplitter.setDoubleBuffered(true);
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.mySplitter.setFirstComponent(firstComponent);
        this.mySplitter.setSecondComponent(this.myFictivePanel);
        this.mySplitter.setProportion(1.0f);
    }

    @NotNull
    public Splitter getComponent() {
        PseudoSplitter pseudoSplitter = this.mySplitter;
        if (pseudoSplitter == null) {
            SplitterWithSecondHideable.$$$reportNull$$$0(3);
        }
        return pseudoSplitter;
    }

    protected abstract RefreshablePanel createDetails();

    protected abstract float getSplitterInitialProportion();

    public float getUsedProportion() {
        return this.isOn() ? this.mySplitter.getProportion() : this.myPreviousProportion;
    }

    public void initOn() {
        this.myTitledSeparator.initOn();
    }

    public void setInitialProportion() {
        this.myTitledSeparator.setInitialProportion();
    }

    public boolean isOn() {
        return this.myTitledSeparator.isOn();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separatorText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/SplitterWithSecondHideable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/SplitterWithSecondHideable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static interface OnOffListener {
        public void on(int var1);

        public void off(int var1);
    }

    private final class MyTitledSeparator
    extends AbstractTitledSeparatorWithIcon {
        MyTitledSeparator(String separatorText, boolean vertical) {
            if (separatorText == null) {
                MyTitledSeparator.$$$reportNull$$$0(0);
            }
            super(AllIcons.General.ArrowRight, vertical ? AllIcons.General.ArrowDown : Objects.requireNonNull(IconLoader.getDisabledIcon((Icon)AllIcons.General.ArrowRight)), separatorText);
        }

        public boolean isOn() {
            return this.myOn;
        }

        public JSeparator getSeparator() {
            return this.mySeparator;
        }

        protected RefreshablePanel createPanel() {
            return SplitterWithSecondHideable.this.createDetails();
        }

        protected void initOnImpl() {
            SplitterWithSecondHideable.this.mySplitter.setSecondComponent(this.myDetailsComponent.getPanel());
            SplitterWithSecondHideable.this.mySplitter.setResizeEnabled(true);
        }

        public void setInitialProportion() {
            float proportion = SplitterWithSecondHideable.this.myPreviousProportion > 0.0f ? SplitterWithSecondHideable.this.myPreviousProportion : SplitterWithSecondHideable.this.getSplitterInitialProportion();
            SplitterWithSecondHideable.this.mySplitter.fixFirst(proportion);
            SplitterWithSecondHideable.this.mySplitter.invalidate();
            SplitterWithSecondHideable.this.mySplitter.validate();
            SplitterWithSecondHideable.this.mySplitter.repaint();
        }

        protected void onImpl() {
            float proportion = SplitterWithSecondHideable.this.myPreviousProportion > 0.0f ? SplitterWithSecondHideable.this.myPreviousProportion : SplitterWithSecondHideable.this.getSplitterInitialProportion();
            int firstSize = SplitterWithSecondHideable.this.mySplitter.isVertical() ? SplitterWithSecondHideable.this.mySplitter.getFirstComponent().getHeight() : SplitterWithSecondHideable.this.mySplitter.getFirstComponent().getWidth();
            SplitterWithSecondHideable.this.mySplitter.fixFirst();
            SplitterWithSecondHideable.this.myListener.on((int)((1.0f - proportion) * (float)firstSize / proportion));
            SplitterWithSecondHideable.this.mySplitter.setSecondComponent(this.myDetailsComponent.getPanel());
            SplitterWithSecondHideable.this.mySplitter.revalidate();
            SplitterWithSecondHideable.this.mySplitter.repaint();
            SplitterWithSecondHideable.this.mySplitter.setResizeEnabled(true);
        }

        protected void offImpl() {
            int previousSize = SplitterWithSecondHideable.this.mySplitter.isVertical() ? SplitterWithSecondHideable.this.mySplitter.getSecondComponent().getHeight() : SplitterWithSecondHideable.this.mySplitter.getSecondComponent().getWidth();
            SplitterWithSecondHideable.this.mySplitter.setSecondComponent(SplitterWithSecondHideable.this.myFictivePanel);
            SplitterWithSecondHideable.this.myPreviousProportion = SplitterWithSecondHideable.this.mySplitter.getProportion();
            SplitterWithSecondHideable.this.mySplitter.freeAll();
            SplitterWithSecondHideable.this.mySplitter.setProportion(1.0f);
            SplitterWithSecondHideable.this.mySplitter.revalidate();
            SplitterWithSecondHideable.this.mySplitter.repaint();
            SplitterWithSecondHideable.this.myListener.off(previousSize);
            SplitterWithSecondHideable.this.mySplitter.setResizeEnabled(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separatorText", "com/intellij/openapi/vcs/changes/ui/SplitterWithSecondHideable$MyTitledSeparator", "<init>"));
        }
    }

    private final class MySplitter
    extends PseudoSplitter {
        @NotNull
        private final MouseEventHandler myMouseListener;

        MySplitter(boolean vertical) {
            super(vertical);
            this.myMouseListener = new MouseEventHandler(){

                public void mouseEntered(MouseEvent event) {
                    SplitterWithSecondHideable.this.myTitledSeparator.getSeparator().setCursor(new Cursor(SplitterWithSecondHideable.this.isOn() ? 9 : 0));
                    super.mouseEntered(event);
                }

                public void mouseExited(MouseEvent event) {
                    SplitterWithSecondHideable.this.myTitledSeparator.getSeparator().setCursor(new Cursor(0));
                    super.mouseExited(event);
                }

                protected void handle(MouseEvent event) {
                    if (event.getID() == 506 || event.getID() == 503) {
                        ((MyDivider)MySplitter.this.myDivider).processMouseMotionEvent(event);
                    } else {
                        ((MyDivider)MySplitter.this.myDivider).processMouseEvent(event);
                    }
                }
            };
            SplitterWithSecondHideable.this.myTitledSeparator.getSeparator().addMouseListener((MouseListener)this.myMouseListener);
            SplitterWithSecondHideable.this.myTitledSeparator.getSeparator().addMouseMotionListener((MouseMotionListener)this.myMouseListener);
        }

        protected Divider createDivider() {
            MyDivider divider = new MyDivider();
            divider.add((Component)((Object)SplitterWithSecondHideable.this.myTitledSeparator), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
            return divider;
        }

        public int getDividerWidth() {
            return this.isVertical() ? SplitterWithSecondHideable.this.myTitledSeparator.getHeight() : SplitterWithSecondHideable.this.myTitledSeparator.getWidth();
        }

        private final class MyDivider
        extends Splitter.DividerImpl {
            private MyDivider() {
                super((Splitter)MySplitter.this);
            }

            public void processMouseMotionEvent(MouseEvent e) {
                super.processMouseMotionEvent(e);
            }

            public void processMouseEvent(MouseEvent e) {
                super.processMouseEvent(e);
            }
        }
    }
}

