/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrCreateFromUsageBaseFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;

public class GrCreateFieldFromUsageFix
extends GrCreateFromUsageBaseFix {
    @NotNull
    private final String myReferenceName;

    public GrCreateFieldFromUsageFix(GrReferenceExpression refExpression, @NotNull String referenceName) {
        if (referenceName == null) {
            GrCreateFieldFromUsageFix.$$$reportNull$$$0(0);
        }
        super(refExpression);
        this.myReferenceName = referenceName;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiElement parent;
        List<PsiClass> classes;
        if (project == null) {
            GrCreateFieldFromUsageFix.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GrCreateFieldFromUsageFix.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            GrCreateFieldFromUsageFix.$$$reportNull$$$0(3);
        }
        if ((classes = this.getTargetClasses()).isEmpty()) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                GrCreateFieldFromUsageFix.$$$reportNull$$$0(4);
            }
            return intentionPreviewInfo;
        }
        PsiClass targetClass = classes.get(0);
        CreateFieldFix fix = new CreateFieldFix(targetClass);
        PsiField representation = fix.getFieldRepresentation(targetClass.getProject(), this.generateModifiers(targetClass), this.myReferenceName, this.getRefExpr(), true);
        PsiElement psiElement = parent = representation == null ? null : representation.getParent();
        if (parent == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                GrCreateFieldFromUsageFix.$$$reportNull$$$0(5);
            }
            return intentionPreviewInfo;
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)GroovyFileType.GROOVY_FILE_TYPE, "", parent.getText());
    }

    private String[] generateModifiers(@NotNull PsiClass targetClass) {
        GrReferenceExpression myRefExpression;
        if (targetClass == null) {
            GrCreateFieldFromUsageFix.$$$reportNull$$$0(6);
        }
        if ((myRefExpression = this.getRefExpr()) != null && GrStaticChecker.isInStaticContext(myRefExpression, targetClass)) {
            return new String[]{"static"};
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    private TypeConstraint[] calculateTypeConstrains() {
        return GroovyExpectedTypesProvider.calculateTypeConstraints(this.getRefExpr());
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.field.from.usage.family.name", new Object[0]);
        if (string == null) {
            GrCreateFieldFromUsageFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getText() {
        String string = GroovyBundle.message("create.field.from.usage", this.myReferenceName);
        if (string == null) {
            GrCreateFieldFromUsageFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    protected void invokeImpl(Project project, @NotNull PsiClass targetClass) {
        if (targetClass == null) {
            GrCreateFieldFromUsageFix.$$$reportNull$$$0(9);
        }
        CreateFieldFix fix = new CreateFieldFix(targetClass);
        fix.doFix(targetClass.getProject(), this.generateModifiers(targetClass), this.myReferenceName, this.calculateTypeConstrains(), this.getRefExpr());
    }

    @Override
    protected boolean canBeTargetClass(PsiClass psiClass) {
        return super.canBeTargetClass(psiClass) && !psiClass.isInterface() && !psiClass.isAnnotationType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFieldFromUsageFix";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/GrCreateFieldFromUsageFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateModifiers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

