/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;

public abstract class AbstractKotlinUpDownMover
extends LineMover {
    protected AbstractKotlinUpDownMover() {
    }

    protected abstract boolean checkSourceElement(@NotNull PsiElement var1);

    protected abstract LineRange getElementSourceLineRange(@NotNull PsiElement var1, @NotNull Editor var2, @NotNull LineRange var3);

    @Nullable
    protected LineRange getSourceRange(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement, @NotNull Editor editor, LineRange oldRange) {
        KtBlockExpression block;
        if (firstElement == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(0);
        }
        if (lastElement == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(2);
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)lastElement);
        int topExtension = 0;
        int bottomExtension = 0;
        if (parent instanceof KtFunctionLiteral && (block = ((KtFunctionLiteral)parent).getBodyExpression()) != null) {
            PsiElement comment = null;
            boolean extendDown = false;
            if (AbstractKotlinUpDownMover.checkCommentAtBlockBound(firstElement, lastElement, block)) {
                comment = lastElement;
                extendDown = true;
                lastElement = block.getLastChild();
            } else if (AbstractKotlinUpDownMover.checkCommentAtBlockBound(lastElement, firstElement, block)) {
                comment = firstElement;
                firstElement = block.getFirstChild();
            }
            if (comment != null) {
                int extension = FormatterUtilKt.getLineCount(comment);
                if (extendDown) {
                    bottomExtension = extension;
                } else {
                    topExtension = extension;
                }
            }
            parent = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)lastElement);
        }
        if (parent == null) {
            return null;
        }
        Pair originalRange = AbstractKotlinUpDownMover.getElementRange((PsiElement)parent, (PsiElement)firstElement, (PsiElement)lastElement);
        if (!this.checkSourceElement((PsiElement)originalRange.first) || !this.checkSourceElement((PsiElement)originalRange.second)) {
            return null;
        }
        LineRange lineRange1 = this.getElementSourceLineRange((PsiElement)originalRange.first, editor, oldRange);
        if (lineRange1 == null) {
            return null;
        }
        LineRange lineRange2 = this.getElementSourceLineRange((PsiElement)originalRange.second, editor, oldRange);
        if (lineRange2 == null) {
            return null;
        }
        LineRange parentLineRange = this.getElementSourceLineRange(parent, editor, oldRange);
        LineRange sourceRange = new LineRange(lineRange1.startLine - topExtension, lineRange2.endLine + bottomExtension);
        if (parentLineRange != null && sourceRange.startLine == parentLineRange.startLine && sourceRange.endLine == parentLineRange.endLine) {
            sourceRange.firstElement = sourceRange.lastElement = parent;
        } else {
            sourceRange.firstElement = (PsiElement)originalRange.first;
            sourceRange.lastElement = (PsiElement)originalRange.second;
        }
        return sourceRange;
    }

    protected static int getElementLine(@Nullable PsiElement element, @NotNull Editor editor, boolean first) {
        if (editor == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(3);
        }
        if (element == null) {
            return -1;
        }
        Document doc = editor.getDocument();
        TextRange spaceRange = element.getTextRange();
        return first ? doc.getLineNumber(spaceRange.getStartOffset()) : doc.getLineNumber(spaceRange.getEndOffset());
    }

    protected static PsiElement getLastNonWhiteSiblingInLine(@Nullable PsiElement element, @NotNull Editor editor, boolean down) {
        if (editor == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(4);
        }
        if (element == null) {
            return null;
        }
        int line = AbstractKotlinUpDownMover.getElementLine(element, editor, down);
        PsiElement lastElement = element;
        while (true) {
            if (lastElement == null) {
                return null;
            }
            PsiElement sibling = AbstractKotlinUpDownMover.firstNonWhiteSibling(lastElement, down);
            if (AbstractKotlinUpDownMover.getElementLine(sibling, editor, down) != line) break;
            lastElement = sibling;
        }
        return lastElement;
    }

    @Nullable
    protected static KtAnnotationEntry getParentFileAnnotationEntry(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        KtAnnotationEntry annotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)element, KtAnnotationEntry.class);
        if (annotationEntry == null) {
            return null;
        }
        KtAnnotationUseSiteTarget useSiteTarget = annotationEntry.getUseSiteTarget();
        if (useSiteTarget == null) {
            return null;
        }
        ASTNode node = useSiteTarget.getNode().getFirstChildNode();
        if (node == null) {
            return null;
        }
        if (node.getElementType() != KtTokens.FILE_KEYWORD) {
            return null;
        }
        return annotationEntry;
    }

    private static boolean checkCommentAtBlockBound(PsiElement blockElement, PsiElement comment, KtBlockExpression block) {
        return PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)blockElement, (boolean)true) && comment instanceof PsiComment;
    }

    @Nullable
    protected static PsiElement getSiblingOfType(@NotNull PsiElement element, boolean down, @NotNull Class<? extends PsiElement> type) {
        if (element == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(5);
        }
        if (type == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(6);
        }
        return down ? PsiTreeUtil.getNextSiblingOfType((PsiElement)element, type) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, type);
    }

    @Nullable
    protected static PsiElement firstNonWhiteSibling(@NotNull LineRange lineRange, boolean down) {
        if (lineRange == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(7);
        }
        return AbstractKotlinUpDownMover.firstNonWhiteElement((PsiElement)(down ? lineRange.lastElement.getNextSibling() : lineRange.firstElement.getPrevSibling()), (boolean)down);
    }

    @Nullable
    protected static PsiElement firstNonWhiteSibling(@NotNull PsiElement element, boolean down) {
        if (element == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(8);
        }
        return AbstractKotlinUpDownMover.firstNonWhiteElement((PsiElement)(down ? element.getNextSibling() : element.getPrevSibling()), (boolean)down);
    }

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(9);
        }
        if (file == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(10);
        }
        if (info == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(11);
        }
        return file.getFileType() instanceof KotlinFileType && super.checkAvailable(editor, file, info, down);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractKotlinUpDownMover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastNonWhiteSiblingInLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getSiblingOfType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "firstNonWhiteSibling";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

