/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Measurement;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.util.Edge;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class LabelToken {
    private String text;
    private String key;
    private Object data;
    private int tok;
    private int pt = -1;
    private char ch1 = '\u0000';
    private int width;
    private int precision = Integer.MAX_VALUE;
    private boolean alignLeft;
    private boolean zeroPad;
    private boolean intAsFloat;
    private static final String labelTokenParams = "AaBbCcDEefGgIiLlMmNnOoPpQqRrSsTtUuVvWwXxxYyyZzz%%%gqW";
    private static final int[] labelTokenIds = new int[]{1086324739, 1086326786, 1086326785, 1111492620, 1631586315, 1086326788, 1094713347, 1086324746, 1086326789, 1111490569, 1094713357, 0x41400011, 1111492618, 1094715393, 1094713363, 1094715402, 1094717454, 1086324743, 0x41400010, 1086324742, 79, 1088421903, 1111492619, 1111490570, 81, 1128269825, 1094715412, 1086324747, 1094713369, 1086326788, 1111490574, 1111492620, 1086324745, 1111490575, 1648363544, 1145047055, 0x44000011, 1086324755, 1111492612, 1111492609, 1111492629, 1111492613, 1111492610, 1111492630, 1111492614, 1111492611, 1111492631, 1114249217, 1112152066, 1112150019, 1112150020, 1112150021, 1112152070, 1112152071, 1112152073, 1112152074, 1112152076, 1649022989, 1112152078, 1111490561, 0x42400002, 1153433601, 1094713346, 1228931586, 1765808134, 1094713356, 0x42400004, 1228935687, 1287653388, 1825200146, 1111490567, 1094713359, 1111490565, 1111490568, 1094713362, 1715472409, 1665140738, 1113589787, 0x40C0000C, 1086324744, 1112152075, 1639976963, 1237320707, 1094713370, 1086324749, 1086326798, 1111490576, 1111490577, 1111490578, 1111490579, 1094715420, 1648361473, 1111492626, 1111492627, 1111492628, 1312817669, 0x4440000E, 1145047050, 1145047049, 1145047053, 1111492615, 1111492616, 1111492617, 1113589786, 1094713365, 1094713366, 1094713367, 1145047052, 1111490566, 1111490563, 1094713351, 1094713368, 1111490583, 1111490584, 1111490585, 1111490586, 0x44400010, 1296041986, 1073877011, 1086324752, 1086324753, 1086324754, 0x4440000B, 1095241729};
    public static final String STANDARD_LABEL = "%[identify]";
    private static final String twoCharLabelTokenParams = "fuv";
    private static final int[] twoCharLabelTokenIds = new int[]{1111492612, 1111492613, 1111492614, 1111490577, 1111490578, 1111490579, 1111492626, 1111492627, 1111492628};

    private LabelToken set(String text, int pt) {
        this.text = text;
        this.pt = pt;
        return this;
    }

    private static boolean isLabelPropertyTok(int tok) {
        int i = labelTokenIds.length;
        while (--i >= 0) {
            if (labelTokenIds[i] != tok) continue;
            return true;
        }
        return false;
    }

    public static LabelToken[] compile(Viewer vwr, String strFormat, char chAtom, Map<String, Object> htValues) {
        int ichPercent;
        if (strFormat == null || strFormat.length() == 0) {
            return null;
        }
        if (strFormat.indexOf("%") < 0 || strFormat.length() < 2) {
            return new LabelToken[]{new LabelToken().set(strFormat, -1)};
        }
        int n = 0;
        int ich = -1;
        int cch = strFormat.length();
        while (++ich < cch && (ich = strFormat.indexOf(37, ich)) >= 0) {
            ++n;
        }
        LabelToken[] tokens = new LabelToken[n * 2 + 1];
        int i = 0;
        ich = 0;
        while ((ichPercent = strFormat.indexOf(37, ich)) >= 0) {
            if (ich != ichPercent) {
                tokens[i++] = new LabelToken().set(strFormat.substring(ich, ichPercent), -1);
            }
            int n2 = i++;
            LabelToken labelToken = new LabelToken().set(null, ichPercent);
            tokens[n2] = labelToken;
            LabelToken lt = labelToken;
            vwr.autoCalculate(lt.tok, null);
            ich = LabelToken.setToken(vwr, strFormat, lt, cch, chAtom, htValues);
        }
        if (ich < cch) {
            tokens[i++] = new LabelToken().set(strFormat.substring(ich), -1);
        }
        return tokens;
    }

    public String formatLabel(Viewer vwr, Atom atom, String strFormat, P3 ptTemp) {
        return strFormat == null || strFormat.length() == 0 ? null : LabelToken.formatLabelAtomArray(vwr, atom, LabelToken.compile(vwr, strFormat, '\u0000', null), '\u0000', null, ptTemp);
    }

    public static String formatLabelAtomArray(Viewer vwr, Atom atom, LabelToken[] tokens, char chAtom, int[] indices, P3 ptTemp) {
        SB strLabel;
        if (atom == null) {
            return null;
        }
        SB sB = strLabel = chAtom > '0' ? null : new SB();
        if (tokens != null) {
            LabelToken t;
            for (int i = 0; i < tokens.length && (t = tokens[i]) != null; ++i) {
                if (chAtom > '0' && t.ch1 != chAtom) continue;
                if (t.tok <= 0 || t.key != null) {
                    if (strLabel == null) continue;
                    strLabel.append(t.text);
                    if (t.ch1 == '\u0000') continue;
                    strLabel.appendC(t.ch1);
                    continue;
                }
                LabelToken.appendAtomTokenValue(vwr, atom, t, strLabel, indices, ptTemp);
            }
        }
        return strLabel == null ? null : strLabel.toString().intern();
    }

    public static Map<String, Object> getBondLabelValues() {
        Hashtable<String, Object> htValues = new Hashtable<String, Object>();
        htValues.put("#", "");
        htValues.put("ORDER", "");
        htValues.put("TYPE", "");
        htValues.put("LENGTH", Float.valueOf(0.0f));
        htValues.put("ENERGY", Float.valueOf(0.0f));
        return htValues;
    }

    public static String formatLabelBond(Viewer vwr, Bond bond, LabelToken[] tokens, Map<String, Object> values, int[] indices, P3 ptTemp) {
        values.put("#", "" + (bond.index + 1));
        values.put("ORDER", "" + Edge.getBondOrderNumberFromOrder(bond.order));
        values.put("TYPE", Edge.getBondOrderNameFromOrder(bond.order));
        values.put("LENGTH", Float.valueOf(bond.atom1.distance(bond.atom2)));
        values.put("ENERGY", Float.valueOf(bond.getEnergy()));
        LabelToken.setValues(tokens, values);
        LabelToken.formatLabelAtomArray(vwr, bond.atom1, tokens, '1', indices, ptTemp);
        LabelToken.formatLabelAtomArray(vwr, bond.atom2, tokens, '2', indices, ptTemp);
        return LabelToken.getLabel(tokens);
    }

    public static String formatLabelMeasure(Viewer vwr, Measurement m, String label, float value, String units) {
        Hashtable<String, Object> htValues = new Hashtable<String, Object>();
        htValues.put("#", "" + (m.index + 1));
        htValues.put("VALUE", Float.valueOf(value));
        htValues.put("UNITS", units);
        LabelToken[] tokens = LabelToken.compile(vwr, label, '\u0001', htValues);
        if (tokens == null) {
            return "";
        }
        LabelToken.setValues(tokens, htValues);
        Atom[] atoms = m.ms.at;
        int[] indices = m.countPlusIndices;
        for (int i = indices[0]; i >= 1; --i) {
            if (indices[i] < 0) continue;
            LabelToken.formatLabelAtomArray(vwr, atoms[indices[i]], tokens, (char)(48 + i), null, null);
        }
        label = LabelToken.getLabel(tokens);
        return label == null ? "" : label;
    }

    public static void setValues(LabelToken[] tokens, Map<String, Object> values) {
        LabelToken lt;
        for (int i = 0; i < tokens.length && (lt = tokens[i]) != null; ++i) {
            if (lt.key == null) continue;
            Object value = values.get(lt.key);
            lt.text = value instanceof Float ? lt.format(((Float)value).floatValue(), null, null) : lt.format(Float.NaN, (String)value, null);
        }
    }

    public static String getLabel(LabelToken[] tokens) {
        LabelToken lt;
        SB sb = new SB();
        for (int i = 0; i < tokens.length && (lt = tokens[i]) != null; ++i) {
            sb.append(lt.text);
        }
        return sb.toString();
    }

    private static int setToken(Viewer vwr, String strFormat, LabelToken lt, int cch, int chAtom, Map<String, Object> htValues) {
        char ch;
        int ich = lt.pt + 1;
        if (ich >= cch) {
            lt.text = "%";
            return ich;
        }
        if (strFormat.charAt(ich) == '-') {
            lt.alignLeft = true;
            ++ich;
        }
        if (ich < cch && strFormat.charAt(ich) == '0') {
            lt.zeroPad = true;
            ++ich;
        }
        while (ich < cch && PT.isDigit(ch = strFormat.charAt(ich))) {
            lt.width = 10 * lt.width + (ch - 48);
            ++ich;
        }
        lt.precision = Integer.MAX_VALUE;
        boolean isNegative = false;
        if (ich < cch && strFormat.charAt(ich) == '.') {
            if (++ich < cch && (ch = strFormat.charAt(ich)) == '-') {
                isNegative = true;
                ++ich;
            }
            if (ich < cch && PT.isDigit(ch = strFormat.charAt(ich))) {
                lt.precision = ch - 48;
                if (++ich < cch && PT.isDigit(ch = strFormat.charAt(ich))) {
                    ++ich;
                    lt.precision = lt.precision * 10 + (ch - 48);
                }
                if (isNegative) {
                    lt.precision = -1 - lt.precision;
                }
            }
        }
        if (ich < cch && htValues != null) {
            for (String key : htValues.keySet()) {
                if (strFormat.indexOf(key, ich) != ich) continue;
                lt.key = key;
                return ich + lt.key.length();
            }
        }
        if (ich < cch) {
            ch = strFormat.charAt(ich++);
            switch (ch) {
                case '%': {
                    lt.text = "%";
                    return ich;
                }
                case '[': {
                    int ichClose = strFormat.indexOf(93, ich);
                    if (ichClose < ich) {
                        ich = cch;
                        break;
                    }
                    String propertyName = strFormat.substring(ich, ichClose).toLowerCase();
                    if (propertyName.startsWith("property_")) {
                        lt.tok = 134221834;
                        lt.data = vwr.getDataObj(propertyName, null, 1);
                    } else if (propertyName.startsWith("validation.")) {
                        lt.tok = 1073742189;
                        lt.data = vwr.getDataObj("property_" + propertyName.substring(11), null, 1);
                    } else if (propertyName.startsWith("unitid")) {
                        lt.tok = 1073741974;
                        lt.data = JC.getUnitIDFlags(propertyName.substring(6));
                    } else {
                        T token = T.getTokenFromName(propertyName);
                        if (token != null && LabelToken.isLabelPropertyTok(token.tok)) {
                            lt.tok = token.tok;
                        }
                    }
                    ich = ichClose + 1;
                    break;
                }
                case '{': {
                    int ichCloseBracket = strFormat.indexOf(125, ich);
                    if (ichCloseBracket < ich) {
                        ich = cch;
                        break;
                    }
                    String s = strFormat.substring(ich, ichCloseBracket);
                    lt.data = vwr.getDataObj(s, null, 1);
                    if (lt.data == null) {
                        lt.data = vwr.getDataObj(s, null, -1);
                        if (lt.data != null) {
                            lt.data = ((Object[])lt.data)[1];
                            if (lt.data instanceof String) {
                                lt.data = PT.split((String)lt.data, "\n");
                            }
                            if (!AU.isAS(lt.data)) {
                                lt.data = null;
                            }
                        }
                        if (lt.data == null) {
                            lt.tok = 1715472409;
                            lt.data = s;
                        } else {
                            lt.tok = 1275068418;
                        }
                    } else {
                        lt.tok = 134221834;
                    }
                    ich = ichCloseBracket + 1;
                    break;
                }
                default: {
                    int i1;
                    int i;
                    if (ich < cch && (i = twoCharLabelTokenParams.indexOf(ch)) >= 0 && (i1 = "xyz".indexOf(strFormat.charAt(ich))) >= 0) {
                        lt.tok = twoCharLabelTokenIds[i * 3 + i1];
                        ++ich;
                        break;
                    }
                    i = labelTokenParams.indexOf(ch);
                    if (i < 0) break;
                    lt.tok = labelTokenIds[i];
                }
            }
        }
        lt.text = strFormat.substring(lt.pt, ich);
        if (ich < cch && chAtom != 0 && PT.isDigit(ch = strFormat.charAt(ich))) {
            ++ich;
            lt.ch1 = ch;
            if (ch != chAtom && chAtom != 1) {
                lt.tok = 0;
            }
        }
        return ich;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void appendAtomTokenValue(Viewer vwr, Atom atom, LabelToken t, SB strLabel, int[] indices, P3 ptTemp) {
        String strT = null;
        float floatT = Float.NaN;
        T3 ptT = null;
        try {
            switch (t.tok) {
                case 1153433601: {
                    strT = atom.atomPropertyString(vwr, 1153433601);
                    break;
                }
                case 1094713347: {
                    strT = "" + (indices == null ? atom.i : indices[atom.i]);
                    break;
                }
                case 1765808134: {
                    ptT = atom.atomPropertyTuple(vwr, t.tok, ptTemp);
                    break;
                }
                case 1073741974: {
                    strT = atom.getUnitID((Integer)t.data);
                    break;
                }
                case 134221834: 
                case 1073742189: {
                    if (t.data == null) break;
                    floatT = ((float[])t.data)[atom.i];
                    if (t.tok != 1073742189 || floatT == 1.0f || floatT == 0.0f) break;
                    Lst<Float> o = vwr.getAtomValidation(t.text.substring(13, t.text.length() - 1), atom);
                    if (o == null) {
                        System.out.println("?? o is null ??");
                        break;
                    }
                    if (o.size() == 1) {
                        floatT = ((Float)o.get(0)).floatValue();
                        break;
                    }
                    floatT = Float.NaN;
                    strT = "";
                    int n = o.size();
                    for (int i = 0; i < n; ++i) {
                        strT = strT + "," + o.get(i);
                    }
                    if (strT.length() <= 1) break;
                    strT = strT.substring(1);
                    break;
                }
                case 1715472409: {
                    Object data = vwr.ms.getInfo(atom.mi, (String)t.data);
                    int iatom = atom.i - vwr.ms.am[atom.mi].firstAtomIndex;
                    Object o = null;
                    if (iatom >= 0) {
                        if (data instanceof Object[]) {
                            Object[] sdata = (Object[])data;
                            o = iatom < sdata.length ? sdata[iatom] : null;
                        } else if (data instanceof Lst) {
                            Lst list = (Lst)data;
                            Object object = o = iatom < list.size() ? SV.oValue(list.get(iatom)) : null;
                        }
                    }
                    if (o == null) {
                        strT = "";
                        break;
                    }
                    if (o instanceof Float) {
                        floatT = ((Float)o).floatValue();
                        break;
                    }
                    if (o instanceof Integer) {
                        floatT = ((Integer)o).intValue();
                        break;
                    }
                    if (o instanceof T3) {
                        ptT = (T3)o;
                        break;
                    }
                    strT = o.toString();
                    break;
                }
                case 1275068418: {
                    if (t.data == null) break;
                    String[] sdata = (String[])t.data;
                    strT = atom.i < sdata.length ? sdata[atom.i] : "";
                    break;
                }
                case 1631586315: {
                    int formalCharge = atom.getFormalCharge();
                    strT = formalCharge > 0 ? "" + formalCharge + "+" : (formalCharge < 0 ? "" + -formalCharge + "-" : "");
                    break;
                }
                case 1094717454: {
                    strT = atom.getModelNumberForLabel();
                    break;
                }
                case 1128269825: {
                    strT = "" + atom.atomPropertyInt(vwr, t.tok);
                    break;
                }
                case 1665140738: {
                    floatT = atom.atomPropertyFloat(vwr, t.tok, ptTemp);
                    break;
                }
                case 1086324749: {
                    strT = atom.group.getStructureId();
                    break;
                }
                case 1094713370: {
                    int id = atom.group.getStrucNo();
                    strT = id <= 0 ? "" : "" + id;
                    break;
                }
                case 1111490574: {
                    floatT = atom.group.getGroupParameter(1111490574);
                    if (!Float.isNaN(floatT)) break;
                    strT = "null";
                    break;
                }
                case 1111490583: 
                case 1111490584: 
                case 1111490585: 
                case 1111490586: 
                case 1111492626: 
                case 1111492627: 
                case 1111492628: {
                    floatT = atom.atomPropertyFloat(vwr, t.tok, ptTemp);
                    if (!Float.isNaN(floatT)) break;
                    strT = "";
                    break;
                }
                case 1073877011: {
                    strT = vwr.getNBOAtomLabel(atom);
                    break;
                }
                case 1086324747: 
                case 1237320707: 
                case 1639976963: {
                    strT = atom.atomPropertyString(vwr, t.tok);
                    break;
                }
                case 0x44000011: {
                    strT = atom.getIdentityXYZ(ptTemp, 1);
                    break;
                }
                case 1086324754: {
                    strT = atom.getWyckoffPosition(false);
                    break;
                }
                case 1086324755: {
                    strT = atom.getWyckoffPosition(true);
                    break;
                }
                case 79: {
                    strT = atom.getSymmetryOperatorList(false);
                    break;
                }
                case 81: {
                    floatT = (float)atom.getOccupancy100() / 100.0f;
                    break;
                }
                default: {
                    switch (t.tok & 0x43C00000) {
                        case 0x41400000: {
                            if (t.intAsFloat) {
                                floatT = atom.atomPropertyInt(vwr, t.tok);
                                break;
                            }
                            strT = "" + atom.atomPropertyInt(vwr, t.tok);
                            break;
                        }
                        case 0x42400000: {
                            floatT = atom.atomPropertyFloat(vwr, t.tok, ptTemp);
                            break;
                        }
                        case 0x40C00000: {
                            strT = atom.atomPropertyString(vwr, t.tok);
                            break;
                        }
                        case 0x40400000: {
                            ptT = atom.atomPropertyTuple(vwr, t.tok, ptTemp);
                            if (ptT != null) break;
                            strT = "";
                            break;
                        }
                        default: {
                            if (t.tok != 0x4440000B) break;
                            strT = atom.atomPropertyString(vwr, 0x4440000B);
                            break;
                        }
                    }
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            floatT = Float.NaN;
            strT = null;
            ptT = null;
        }
        strT = t.format(floatT, strT, ptT);
        if (strLabel == null) {
            t.text = strT;
            return;
        }
        strLabel.append(strT);
    }

    private String format(float floatT, String strT, T3 ptT) {
        if (!Float.isNaN(floatT)) {
            return PT.formatF(floatT, this.width, this.precision, this.alignLeft, this.zeroPad);
        }
        if (strT != null) {
            return PT.formatS(strT, this.width, this.precision, this.alignLeft, this.zeroPad);
        }
        if (ptT != null) {
            if (this.width == 0 && this.precision == Integer.MAX_VALUE) {
                this.width = 6;
                this.precision = 2;
            }
            return PT.formatF(ptT.x, this.width, this.precision, false, false) + PT.formatF(ptT.y, this.width, this.precision, false, false) + PT.formatF(ptT.z, this.width, this.precision, false, false);
        }
        return this.text;
    }
}

