/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.SortDirection;
import org.hibernate.query.sqm.function.SelfRenderingWindowFunctionSqlAstExpression;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Over;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.BasicType;

public final class SqmInsertStrategyHelper {
    private SqmInsertStrategyHelper() {
    }

    public static Expression createRowNumberingExpression(QuerySpec querySpec, SessionFactoryImplementor sessionFactory) {
        List<SortSpecification> orderList;
        SelfRenderingWindowFunctionSqlAstExpression<Integer> functionExpression;
        BasicType<Integer> resultType = sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
        if (querySpec.getSelectClause().isDistinct()) {
            assert (sessionFactory.getJdbcServices().getDialect().supportsWindowFunctions());
            functionExpression = new SelfRenderingWindowFunctionSqlAstExpression<Integer>("dense_rank", (appender, args, returnType, walker) -> appender.appendSql("dense_rank()"), Collections.emptyList(), null, null, null, resultType, resultType);
            List<SortSpecification> sortSpecifications = querySpec.getSortSpecifications();
            List<SqlSelection> sqlSelections = querySpec.getSelectClause().getSqlSelections();
            if (sortSpecifications == null) {
                orderList = new ArrayList<SortSpecification>(sqlSelections.size());
            } else {
                orderList = new ArrayList<SortSpecification>(sortSpecifications.size() + sqlSelections.size());
                orderList.addAll(sortSpecifications);
            }
            for (SqlSelection sqlSelection : sqlSelections) {
                if (SqmInsertStrategyHelper.containsSelectionExpression(orderList, sqlSelection)) continue;
                orderList.add(new SortSpecification(sqlSelection.getExpression(), SortDirection.ASCENDING));
            }
        } else {
            functionExpression = new SelfRenderingWindowFunctionSqlAstExpression<Integer>("row_number", (appender, args, returnType, walker) -> appender.appendSql("row_number()"), Collections.emptyList(), null, null, null, resultType, resultType);
            orderList = Collections.emptyList();
        }
        return new Over(functionExpression, Collections.emptyList(), orderList);
    }

    private static boolean containsSelectionExpression(List<SortSpecification> orderList, SqlSelection sqlSelection) {
        Expression expression = sqlSelection.getExpression();
        for (SortSpecification sortSpecification : orderList) {
            SqlSelectionExpression sqlSelectionExpression;
            Expression sortExpression = sortSpecification.getSortExpression();
            if (sortExpression != expression && (!(sortExpression instanceof SqlSelectionExpression) || (sqlSelectionExpression = (SqlSelectionExpression)sortExpression).getSelection() != sqlSelection)) continue;
            return true;
        }
        return false;
    }
}

