/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.complete;

import java.util.List;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.complete.CompleteFetchBuilder;
import org.hibernate.query.results.internal.complete.ModelPartReferenceEmbeddable;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class CompleteFetchBuilderEmbeddableValuedModelPart
implements CompleteFetchBuilder,
ModelPartReferenceEmbeddable {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart modelPart;
    private final List<String> columnAliases;

    public CompleteFetchBuilderEmbeddableValuedModelPart(NavigablePath navigablePath, EmbeddableValuedModelPart modelPart, List<String> columnAliases) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
        this.columnAliases = columnAliases;
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return new CompleteFetchBuilderEmbeddableValuedModelPart(this.navigablePath, this.modelPart, List.copyOf(this.columnAliases));
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public EmbeddableValuedModelPart getReferencedPart() {
        return this.modelPart;
    }

    @Override
    public List<String> getColumnAliases() {
        return this.columnAliases;
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationState domainResultCreationState) {
        assert (fetchPath.equals(this.navigablePath));
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(this.navigablePath.getParent());
        this.modelPart.forEachSelectable((selectionIndex, selectableMapping) -> this.sqlSelection(jdbcResultsMetadata, selectionIndex, selectableMapping, creationStateImpl, tableGroup));
        return parent.generateFetchableFetch(this.modelPart, fetchPath, FetchTiming.IMMEDIATE, true, null, domainResultCreationState);
    }

    private void sqlSelection(JdbcValuesMetadata jdbcResultsMetadata, int selectionIndex, SelectableMapping selectableMapping, DomainResultCreationStateImpl creationStateImpl, TableGroup tableGroup) {
        creationStateImpl.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, jdbcResultsMetadata, tableGroup.resolveTableReference(this.navigablePath, this.modelPart, selectableMapping.getContainingTableExpression()), selectableMapping, this.columnAliases.get(selectionIndex)), selectableMapping.getJdbcMapping().getJdbcJavaType(), null, creationStateImpl.getSessionFactory().getTypeConfiguration());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteFetchBuilderEmbeddableValuedModelPart that = (CompleteFetchBuilderEmbeddableValuedModelPart)o;
        return this.navigablePath.equals(that.navigablePath) && this.modelPart.equals(that.modelPart) && this.columnAliases.equals(that.columnAliases);
    }

    public int hashCode() {
        int result = this.navigablePath.hashCode();
        result = 31 * result + this.modelPart.hashCode();
        result = 31 * result + this.columnAliases.hashCode();
        return result;
    }
}

