/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import mediathek.mac.MacFileUtils;
import mediathek.tool.FileUtils;
import mediathek.windows.WindowsFileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0007J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\tH\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lmediathek/tool/FileUtils;", "", "<init>", "()V", "moveToTrash", "", "filePath", "Ljava/nio/file/Path;", "ONE_KB", "", "ONE_MB", "ONE_GB", "removeExtension", "", "fileName", "deletePathRecursively", "rootPath", "humanReadableByteCountBinary", "bytes", "MediathekView"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;

    private FileUtils() {
    }

    @JvmStatic
    public static final void moveToTrash(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            if (SystemUtils.IS_OS_MAC_OSX) {
                File[] fileArray = new File[]{filePath.toFile()};
                MacFileUtils.moveToTrash(fileArray);
            } else if (SystemUtils.IS_OS_WINDOWS) {
                File[] fileArray = new File[]{filePath.toFile()};
                WindowsFileUtils.moveToTrash(fileArray);
            } else {
                Files.deleteIfExists(filePath);
            }
        }
        catch (IOException iOException) {
            Files.deleteIfExists(filePath);
        }
    }

    @JvmStatic
    @NotNull
    public static final String removeExtension(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return FilesKt.getNameWithoutExtension((File)new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void deletePathRecursively(@NotNull Path rootPath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        AutoCloseable autoCloseable = Files.walk(rootPath, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream walk = (Stream)autoCloseable;
            boolean bl = false;
            walk.sorted(Comparator.reverseOrder()).map(arg_0 -> FileUtils.deletePathRecursively$lambda$0$0(deletePathRecursively.1.1.INSTANCE, arg_0)).forEach(arg_0 -> FileUtils.deletePathRecursively$lambda$0$1(deletePathRecursively.1.2.INSTANCE, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @JvmStatic
    @NotNull
    public static final String humanReadableByteCountBinary(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        String string = "%.1f %ciB";
        Object[] objectArray = new Object[]{(double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final File deletePathRecursively$lambda$0$0(Function1 $tmp0, Object p0) {
        return (File)$tmp0.invoke(p0);
    }

    private static final void deletePathRecursively$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

