/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.sort;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.common.geo.GeoDistance;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.unit.DistanceUnit;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.protobufs.GeoDistanceSort;
import org.opensearch.protobufs.GeoDistanceType;
import org.opensearch.protobufs.GeoLocation;
import org.opensearch.protobufs.GeoLocationArray;
import org.opensearch.protobufs.GeoValidationMethod;
import org.opensearch.search.sort.GeoDistanceSortBuilder;
import org.opensearch.search.sort.NestedSortBuilder;
import org.opensearch.search.sort.SortMode;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.transport.grpc.proto.request.common.GeoPointProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.sort.NestedSortProtoUtils;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;
import org.opensearch.transport.grpc.util.ProtobufEnumUtils;

public class GeoDistanceSortProtoUtils {
    private GeoDistanceSortProtoUtils() {
    }

    public static GeoDistanceSortBuilder fromProto(GeoDistanceSort geoDistanceSort, QueryBuilderProtoConverterRegistry registry) {
        if (geoDistanceSort == null) {
            throw new IllegalArgumentException("GeoDistanceSort cannot be null");
        }
        String fieldName = null;
        List<GeoPoint> geoPoints = null;
        DistanceUnit unit = DistanceUnit.DEFAULT;
        GeoDistance geoDistance = GeoDistance.ARC;
        SortOrder order = SortOrder.ASC;
        SortMode sortMode = null;
        QueryBuilder nestedFilter = null;
        String nestedPath = null;
        NestedSortBuilder nestedSort = null;
        org.opensearch.index.query.GeoValidationMethod validation = null;
        boolean ignoreUnmapped = false;
        if (geoDistanceSort.hasOrder()) {
            order = SortOrder.fromString((String)ProtobufEnumUtils.convertToString(geoDistanceSort.getOrder()));
        }
        if (geoDistanceSort.hasUnit() && geoDistanceSort.getUnit() != org.opensearch.protobufs.DistanceUnit.DISTANCE_UNIT_UNSPECIFIED) {
            unit = DistanceUnit.fromString((String)ProtobufEnumUtils.convertToString(geoDistanceSort.getUnit()));
        }
        if (geoDistanceSort.hasDistanceType() && geoDistanceSort.getDistanceType() != GeoDistanceType.GEO_DISTANCE_TYPE_UNSPECIFIED) {
            geoDistance = GeoDistance.fromString((String)ProtobufEnumUtils.convertToString(geoDistanceSort.getDistanceType()));
        }
        if (geoDistanceSort.hasValidationMethod() && geoDistanceSort.getValidationMethod() != GeoValidationMethod.GEO_VALIDATION_METHOD_UNSPECIFIED) {
            validation = org.opensearch.index.query.GeoValidationMethod.fromString((String)ProtobufEnumUtils.convertToString(geoDistanceSort.getValidationMethod()));
        }
        if (geoDistanceSort.hasMode() && geoDistanceSort.getMode() != org.opensearch.protobufs.SortMode.SORT_MODE_UNSPECIFIED) {
            sortMode = SortMode.fromString((String)ProtobufEnumUtils.convertToString(geoDistanceSort.getMode()));
        }
        if (geoDistanceSort.hasIgnoreUnmapped()) {
            ignoreUnmapped = geoDistanceSort.getIgnoreUnmapped();
        }
        if (geoDistanceSort.hasNested()) {
            nestedSort = NestedSortProtoUtils.fromProto(geoDistanceSort.getNested(), registry);
        }
        if (geoDistanceSort.getLocationCount() == 0) {
            throw new IllegalArgumentException("GeoDistanceSort must contain at least one geo location");
        }
        if (geoDistanceSort.getLocationCount() > 1) {
            throw new IllegalArgumentException("GeoDistanceSort supports only one field, but found " + geoDistanceSort.getLocationCount() + " fields");
        }
        fieldName = (String)geoDistanceSort.getLocationMap().keySet().iterator().next();
        GeoLocationArray geoLocationArray = (GeoLocationArray)geoDistanceSort.getLocationMap().get(fieldName);
        geoPoints = GeoDistanceSortProtoUtils.extractGeoPoints(geoLocationArray, fieldName);
        GeoDistanceSortBuilder result = new GeoDistanceSortBuilder(fieldName, geoPoints.toArray(new GeoPoint[0]));
        result.geoDistance(geoDistance);
        result.unit(unit);
        result.order(order);
        if (sortMode != null) {
            result.sortMode(sortMode);
        }
        if (nestedFilter != null) {
            result.setNestedFilter(nestedFilter);
        }
        result.setNestedPath(nestedPath);
        if (nestedSort != null) {
            result.setNestedSort(nestedSort);
        }
        if (validation != null) {
            result.validation(validation);
        }
        result.ignoreUnmapped(ignoreUnmapped);
        return result;
    }

    private static List<GeoPoint> extractGeoPoints(GeoLocationArray geoLocationArray, String fieldName) {
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
        for (GeoLocation geoLocation : geoLocationArray.getGeoLocationArrayList()) {
            try {
                GeoPoint point = GeoPointProtoUtils.parseGeoPoint(geoLocation);
                geoPoints.add(point);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid geo location in field '" + fieldName + "': " + e.getMessage(), e);
            }
        }
        if (geoPoints.isEmpty()) {
            throw new IllegalArgumentException("No valid geo locations found in field '" + fieldName + "'");
        }
        return geoPoints;
    }
}

