/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.query;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.opensearch.search.profile.AbstractProfileBreakdown;
import org.opensearch.search.profile.Timer;
import org.opensearch.search.profile.query.QueryTimingType;

final class ProfileScorer
extends Scorer {
    private final Scorer scorer;
    private final Timer scoreTimer;
    private final Timer nextDocTimer;
    private final Timer advanceTimer;
    private final Timer matchTimer;
    private final Timer shallowAdvanceTimer;
    private final Timer computeMaxScoreTimer;
    private final Timer setMinCompetitiveScoreTimer;

    ProfileScorer(Scorer scorer, AbstractProfileBreakdown profile) throws IOException {
        this.scorer = scorer;
        this.scoreTimer = profile.getTimer(QueryTimingType.SCORE);
        this.nextDocTimer = profile.getTimer(QueryTimingType.NEXT_DOC);
        this.advanceTimer = profile.getTimer(QueryTimingType.ADVANCE);
        this.matchTimer = profile.getTimer(QueryTimingType.MATCH);
        this.shallowAdvanceTimer = profile.getTimer(QueryTimingType.SHALLOW_ADVANCE);
        this.computeMaxScoreTimer = profile.getTimer(QueryTimingType.COMPUTE_MAX_SCORE);
        this.setMinCompetitiveScoreTimer = profile.getTimer(QueryTimingType.SET_MIN_COMPETITIVE_SCORE);
    }

    public int docID() {
        return this.scorer.docID();
    }

    public float score() throws IOException {
        this.scoreTimer.start();
        try {
            float f = this.scorer.score();
            return f;
        }
        finally {
            this.scoreTimer.stop();
        }
    }

    public Collection<Scorable.ChildScorable> getChildren() throws IOException {
        return this.scorer.getChildren();
    }

    public DocIdSetIterator iterator() {
        final DocIdSetIterator in = this.scorer.iterator();
        return new DocIdSetIterator(){

            public int advance(int target) throws IOException {
                ProfileScorer.this.advanceTimer.start();
                try {
                    int n = in.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.advanceTimer.stop();
                }
            }

            public int nextDoc() throws IOException {
                ProfileScorer.this.nextDocTimer.start();
                try {
                    int n = in.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.nextDocTimer.stop();
                }
            }

            public int docID() {
                return in.docID();
            }

            public long cost() {
                return in.cost();
            }
        };
    }

    public TwoPhaseIterator twoPhaseIterator() {
        final TwoPhaseIterator in = this.scorer.twoPhaseIterator();
        if (in == null) {
            return null;
        }
        final DocIdSetIterator inApproximation = in.approximation();
        DocIdSetIterator approximation = new DocIdSetIterator(){

            public int advance(int target) throws IOException {
                ProfileScorer.this.advanceTimer.start();
                try {
                    int n = inApproximation.advance(target);
                    return n;
                }
                finally {
                    ProfileScorer.this.advanceTimer.stop();
                }
            }

            public int nextDoc() throws IOException {
                ProfileScorer.this.nextDocTimer.start();
                try {
                    int n = inApproximation.nextDoc();
                    return n;
                }
                finally {
                    ProfileScorer.this.nextDocTimer.stop();
                }
            }

            public int docID() {
                return inApproximation.docID();
            }

            public long cost() {
                return inApproximation.cost();
            }
        };
        return new TwoPhaseIterator(approximation){

            public boolean matches() throws IOException {
                ProfileScorer.this.matchTimer.start();
                try {
                    boolean bl = in.matches();
                    return bl;
                }
                finally {
                    ProfileScorer.this.matchTimer.stop();
                }
            }

            public float matchCost() {
                return in.matchCost();
            }
        };
    }

    public int advanceShallow(int target) throws IOException {
        this.shallowAdvanceTimer.start();
        try {
            int n = this.scorer.advanceShallow(target);
            return n;
        }
        finally {
            this.shallowAdvanceTimer.stop();
        }
    }

    public float getMaxScore(int upTo) throws IOException {
        this.computeMaxScoreTimer.start();
        try {
            float f = this.scorer.getMaxScore(upTo);
            return f;
        }
        finally {
            this.computeMaxScoreTimer.stop();
        }
    }

    public void setMinCompetitiveScore(float minScore) throws IOException {
        this.setMinCompetitiveScoreTimer.start();
        try {
            this.scorer.setMinCompetitiveScore(minScore);
        }
        finally {
            this.setMinCompetitiveScoreTimer.stop();
        }
    }
}

