function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { FixedSizeList } from 'react-window';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiHighlight } from '../../highlight';
import { EuiPanel } from '../../panel';
import { EuiText } from '../../text';
import { EuiLoadingSpinner } from '../../loading';
import { EuiComboBoxTitle } from './combo_box_title';
import { EuiI18n } from '../../i18n';
import { EuiFilterSelectItem } from '../../filter_group/filter_select_item';
import { EuiBadge } from '../../badge/';
var OPTION_CONTENT_CLASSNAME = 'euiComboBoxOption__content';
var hitEnterBadge = /*#__PURE__*/React.createElement(EuiBadge, {
  className: "euiComboBoxOption__enterBadge",
  color: "hollow",
  iconType: "returnKey",
  "aria-hidden": "true"
});
export var EuiComboBoxOptionsList = /*#__PURE__*/function (_Component) {
  _inherits(EuiComboBoxOptionsList, _Component);
  var _super = _createSuper(EuiComboBoxOptionsList);
  function EuiComboBoxOptionsList() {
    var _this;
    _classCallCheck(this, EuiComboBoxOptionsList);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "listRefInstance", null);
    _defineProperty(_assertThisInitialized(_this), "listRef", null);
    _defineProperty(_assertThisInitialized(_this), "listBoxRef", null);
    _defineProperty(_assertThisInitialized(_this), "updatePosition", function () {
      // Wait a beat for the DOM to update, since we depend on DOM elements' bounds.
      requestAnimationFrame(function () {
        _this.props.updatePosition(_this.listRefInstance);
      });
    });
    _defineProperty(_assertThisInitialized(_this), "closeListOnScroll", function (event) {
      // Close the list when a scroll event happens, but not if the scroll happened in the options list.
      // This mirrors Firefox's approach of auto-closing `select` elements onscroll.
      if (_this.listRefInstance && event.target && _this.listRefInstance.contains(event.target) === false) {
        _this.props.onCloseList(event);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "listRefCallback", function (ref) {
      _this.props.listRef(ref);
      _this.listRefInstance = ref;
    });
    _defineProperty(_assertThisInitialized(_this), "setListRef", function (ref) {
      _this.listRef = ref;
    });
    _defineProperty(_assertThisInitialized(_this), "setListBoxRef", function (ref) {
      _this.listBoxRef = ref;
      if (ref) {
        ref.setAttribute('id', _this.props.rootId('listbox'));
        ref.setAttribute('role', 'listBox');
        ref.setAttribute('tabIndex', '0');
      }
    });
    _defineProperty(_assertThisInitialized(_this), "ListRow", function (_ref) {
      var _option$key;
      var data = _ref.data,
        index = _ref.index,
        style = _ref.style;
      var option = data[index];
      var key = option.key,
        isGroupLabelOption = option.isGroupLabelOption,
        label = option.label,
        value = option.value,
        rest = _objectWithoutProperties(option, ["key", "isGroupLabelOption", "label", "value"]);
      var _this$props = _this.props,
        singleSelection = _this$props.singleSelection,
        selectedOptions = _this$props.selectedOptions,
        onOptionClick = _this$props.onOptionClick,
        optionRef = _this$props.optionRef,
        activeOptionIndex = _this$props.activeOptionIndex,
        renderOption = _this$props.renderOption,
        searchValue = _this$props.searchValue,
        rootId = _this$props.rootId;
      if (isGroupLabelOption) {
        return /*#__PURE__*/React.createElement("div", {
          key: key !== null && key !== void 0 ? key : label.toLowerCase(),
          style: style
        }, /*#__PURE__*/React.createElement(EuiComboBoxTitle, null, label));
      }
      var checked = undefined;
      if (singleSelection && selectedOptions.length && selectedOptions[0].label === label && selectedOptions[0].key === key) {
        checked = 'on';
      }
      var optionIsFocused = activeOptionIndex === index;
      var optionIsDisabled = option.hasOwnProperty('disabled') && option.disabled === true;
      return /*#__PURE__*/React.createElement(EuiFilterSelectItem, _extends({
        style: style,
        key: (_option$key = option.key) !== null && _option$key !== void 0 ? _option$key : option.label.toLowerCase(),
        onClick: function onClick() {
          if (onOptionClick) {
            onOptionClick(option);
          }
        },
        ref: optionRef.bind(_assertThisInitialized(_this), index),
        isFocused: optionIsFocused,
        checked: checked,
        showIcons: singleSelection ? true : false,
        id: rootId("_option-".concat(index)),
        title: label
      }, rest), /*#__PURE__*/React.createElement("span", {
        className: "euiComboBoxOption__contentWrapper"
      }, renderOption ? /*#__PURE__*/React.createElement("span", {
        className: OPTION_CONTENT_CLASSNAME
      }, renderOption(option, searchValue, 'euiComboBoxOption__renderOption')) : /*#__PURE__*/React.createElement(EuiHighlight, {
        search: searchValue,
        className: OPTION_CONTENT_CLASSNAME
      }, label), optionIsFocused && !optionIsDisabled ? hitEnterBadge : null));
    });
    return _this;
  }
  _createClass(EuiComboBoxOptionsList, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;
      // Wait a frame, otherwise moving focus from one combo box to another will result in the class
      // being removed from the body.
      requestAnimationFrame(function () {
        document.body.classList.add('euiBody-hasPortalContent');
      });
      this.updatePosition();
      window.addEventListener('resize', this.updatePosition);

      // Firefox will trigger a scroll event in many common situations when the options list div is appended
      // to the DOM; in testing it was always within 100ms, but setting a timeout here for 500ms to be safe
      setTimeout(function () {
        window.addEventListener('scroll', _this2.closeListOnScroll, {
          passive: true,
          // for better performance as we won't call preventDefault
          capture: true // scroll events don't bubble, they must be captured instead
        });
      }, 500);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var options = prevProps.options,
        selectedOptions = prevProps.selectedOptions,
        searchValue = prevProps.searchValue; // We don't compare matchingOptions because that will result in a loop.
      if (searchValue !== this.props.searchValue || options !== this.props.options || selectedOptions !== this.props.selectedOptions) {
        this.updatePosition();
      }
      if (this.listRef && typeof this.props.activeOptionIndex !== 'undefined' && this.props.activeOptionIndex !== prevProps.activeOptionIndex) {
        this.listRef.scrollToItem(this.props.activeOptionIndex, 'auto');
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.body.classList.remove('euiBody-hasPortalContent');
      window.removeEventListener('resize', this.updatePosition);
      window.removeEventListener('scroll', this.closeListOnScroll, {
        capture: true
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        dataTestSubj = _this$props2['data-test-subj'],
        activeOptionIndex = _this$props2.activeOptionIndex,
        areAllOptionsSelected = _this$props2.areAllOptionsSelected,
        customOptionText = _this$props2.customOptionText,
        fullWidth = _this$props2.fullWidth,
        getSelectedOptionForSearchValue = _this$props2.getSelectedOptionForSearchValue,
        isLoading = _this$props2.isLoading,
        listRef = _this$props2.listRef,
        matchingOptions = _this$props2.matchingOptions,
        onCloseList = _this$props2.onCloseList,
        onCreateOption = _this$props2.onCreateOption,
        onOptionClick = _this$props2.onOptionClick,
        onOptionEnterKey = _this$props2.onOptionEnterKey,
        onScroll = _this$props2.onScroll,
        optionRef = _this$props2.optionRef,
        options = _this$props2.options,
        _this$props2$position = _this$props2.position,
        position = _this$props2$position === void 0 ? 'bottom' : _this$props2$position,
        renderOption = _this$props2.renderOption,
        rootId = _this$props2.rootId,
        rowHeight = _this$props2.rowHeight,
        scrollToIndex = _this$props2.scrollToIndex,
        searchValue = _this$props2.searchValue,
        selectedOptions = _this$props2.selectedOptions,
        singleSelection = _this$props2.singleSelection,
        updatePosition = _this$props2.updatePosition,
        width = _this$props2.width,
        delimiter = _this$props2.delimiter,
        zIndex = _this$props2.zIndex,
        style = _this$props2.style,
        rest = _objectWithoutProperties(_this$props2, ["data-test-subj", "activeOptionIndex", "areAllOptionsSelected", "customOptionText", "fullWidth", "getSelectedOptionForSearchValue", "isLoading", "listRef", "matchingOptions", "onCloseList", "onCreateOption", "onOptionClick", "onOptionEnterKey", "onScroll", "optionRef", "options", "position", "renderOption", "rootId", "rowHeight", "scrollToIndex", "searchValue", "selectedOptions", "singleSelection", "updatePosition", "width", "delimiter", "zIndex", "style"]);
      var emptyStateContent;
      if (isLoading) {
        emptyStateContent = /*#__PURE__*/React.createElement(EuiFlexGroup, {
          gutterSize: "s",
          justifyContent: "center"
        }, /*#__PURE__*/React.createElement(EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
          size: "m"
        })), /*#__PURE__*/React.createElement(EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/React.createElement(EuiI18n, {
          token: "euiComboBoxOptionsList.loadingOptions",
          default: "Loading options"
        })));
      } else if (searchValue && matchingOptions && matchingOptions.length === 0) {
        if (onCreateOption && getSelectedOptionForSearchValue) {
          if (delimiter && searchValue.includes(delimiter)) {
            emptyStateContent = /*#__PURE__*/React.createElement("div", {
              className: "euiComboBoxOption__contentWrapper"
            }, /*#__PURE__*/React.createElement("p", {
              className: "euiComboBoxOption__emptyStateText"
            }, /*#__PURE__*/React.createElement(EuiI18n, {
              token: "euiComboBoxOptionsList.delimiterMessage",
              default: "Add each item separated by {delimiter}",
              values: {
                delimiter: /*#__PURE__*/React.createElement("strong", null, delimiter)
              }
            })), hitEnterBadge);
          } else {
            var selectedOptionForValue = getSelectedOptionForSearchValue(searchValue, selectedOptions);
            if (selectedOptionForValue) {
              // Disallow duplicate custom options.
              emptyStateContent = /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(EuiI18n, {
                token: "euiComboBoxOptionsList.alreadyAdded",
                default: "{label} has already been added",
                values: {
                  label: /*#__PURE__*/React.createElement("strong", null, selectedOptionForValue.label)
                }
              }));
            } else {
              var highlightSearchValue = function highlightSearchValue(text, searchValue) {
                var reg = new RegExp(/(\{searchValue})/, 'gi');
                var parts = text.split(reg);
                return /*#__PURE__*/React.createElement("p", {
                  className: "euiComboBoxOption__emptyStateText"
                }, parts.map(function (part, idx) {
                  return part.match(reg) ? /*#__PURE__*/React.createElement("strong", {
                    key: idx
                  }, searchValue) : part;
                }));
              };
              emptyStateContent = /*#__PURE__*/React.createElement("div", {
                className: "euiComboBoxOption__contentWrapper"
              }, customOptionText ? highlightSearchValue(customOptionText, searchValue) : /*#__PURE__*/React.createElement("p", {
                className: "euiComboBoxOption__emptyStateText"
              }, /*#__PURE__*/React.createElement(EuiI18n, {
                token: "euiComboBoxOptionsList.createCustomOption",
                default: "Add {searchValue} as a custom option",
                values: {
                  searchValue: /*#__PURE__*/React.createElement("strong", null, searchValue)
                }
              })), hitEnterBadge);
            }
          }
        } else {
          emptyStateContent = /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(EuiI18n, {
            token: "euiComboBoxOptionsList.noMatchingOptions",
            default: "{searchValue} doesn't match any options",
            values: {
              searchValue: /*#__PURE__*/React.createElement("strong", null, searchValue)
            }
          }));
        }
      } else if (!options.length) {
        emptyStateContent = /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(EuiI18n, {
          token: "euiComboBoxOptionsList.noAvailableOptions",
          default: "There aren't any options available"
        }));
      } else if (areAllOptionsSelected) {
        emptyStateContent = /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(EuiI18n, {
          token: "euiComboBoxOptionsList.allOptionsSelected",
          default: "You've selected all available options"
        }));
      }
      var emptyState = emptyStateContent ? /*#__PURE__*/React.createElement(EuiText, {
        size: "xs",
        className: "euiComboBoxOptionsList__empty"
      }, emptyStateContent) : undefined;
      var numVisibleOptions = matchingOptions.length < 7 ? matchingOptions.length : 7;
      var height = numVisibleOptions * (rowHeight + 1); // Add one for the border

      // bounded by max-height of euiComboBoxOptionsList__rowWrap
      var boundedHeight = height > 200 ? 200 : height;
      var optionsList = /*#__PURE__*/React.createElement(FixedSizeList, {
        height: boundedHeight,
        onScroll: onScroll,
        itemCount: matchingOptions.length,
        itemSize: rowHeight,
        itemData: matchingOptions,
        ref: this.setListRef,
        innerRef: this.setListBoxRef,
        width: width
      }, this.ListRow);

      /**
       * Reusing the EuiPopover__panel classes to help with consistency/maintenance.
       * But this should really be converted to user the popover component.
       */
      var classes = classNames('euiComboBoxOptionsList', 'euiPopover__panel', 'euiPopover__panel-isAttached', 'euiPopover__panel-noArrow', 'euiPopover__panel-isOpen', "euiPopover__panel--".concat(position));
      return /*#__PURE__*/React.createElement(EuiPanel, _extends({
        paddingSize: "none",
        hasShadow: false,
        className: classes,
        panelRef: this.listRefCallback,
        "data-test-subj": "comboBoxOptionsList ".concat(dataTestSubj),
        style: _objectSpread(_objectSpread({}, style), {}, {
          zIndex: zIndex
        })
      }, rest), /*#__PURE__*/React.createElement("div", {
        className: "euiComboBoxOptionsList__rowWrap"
      }, emptyState || optionsList));
    }
  }]);
  return EuiComboBoxOptionsList;
}(Component);
_defineProperty(EuiComboBoxOptionsList, "defaultProps", {
  'data-test-subj': '',
  rowHeight: 29 // row height of default option renderer
});
EuiComboBoxOptionsList.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.oneOfType([PropTypes.string, PropTypes.string.isRequired]),
  activeOptionIndex: PropTypes.number,
  areAllOptionsSelected: PropTypes.bool,
  /**
       * Creates a custom text option. You can use `{searchValue}` inside your string to better customize your text.
       * It won't show if there's no onCreateOption.
       */
  customOptionText: PropTypes.string,
  fullWidth: PropTypes.bool,
  getSelectedOptionForSearchValue: PropTypes.func,
  isLoading: PropTypes.bool,
  listRef: PropTypes.any.isRequired,
  matchingOptions: PropTypes.arrayOf(PropTypes.shape({
    isGroupLabelOption: PropTypes.bool,
    label: PropTypes.string.isRequired,
    key: PropTypes.string,
    options: PropTypes.arrayOf(PropTypes.shape({
      isGroupLabelOption: PropTypes.bool,
      label: PropTypes.string.isRequired,
      key: PropTypes.string,
      options: PropTypes.arrayOf(PropTypes.any.isRequired),
      value: PropTypes.any,
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string
    }).isRequired),
    value: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }).isRequired).isRequired,
  onCloseList: PropTypes.func.isRequired,
  onCreateOption: PropTypes.func,
  onOptionClick: PropTypes.func,
  onOptionEnterKey: PropTypes.func,
  onScroll: PropTypes.any,
  optionRef: PropTypes.func.isRequired,
  /**
       * Array of EuiComboBoxOptionOption objects. See #EuiComboBoxOptionOption
       */
  options: PropTypes.arrayOf(PropTypes.shape({
    isGroupLabelOption: PropTypes.bool,
    label: PropTypes.string.isRequired,
    key: PropTypes.string,
    options: PropTypes.arrayOf(PropTypes.shape({
      isGroupLabelOption: PropTypes.bool,
      label: PropTypes.string.isRequired,
      key: PropTypes.string,
      options: PropTypes.arrayOf(PropTypes.any.isRequired),
      value: PropTypes.any,
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string
    }).isRequired),
    value: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }).isRequired).isRequired,
  position: PropTypes.oneOf(["top", "bottom"]),
  renderOption: PropTypes.func,
  rootId: PropTypes.any.isRequired,
  rowHeight: PropTypes.number.isRequired,
  scrollToIndex: PropTypes.number,
  searchValue: PropTypes.string.isRequired,
  selectedOptions: PropTypes.arrayOf(PropTypes.shape({
    isGroupLabelOption: PropTypes.bool,
    label: PropTypes.string.isRequired,
    key: PropTypes.string,
    options: PropTypes.arrayOf(PropTypes.shape({
      isGroupLabelOption: PropTypes.bool,
      label: PropTypes.string.isRequired,
      key: PropTypes.string,
      options: PropTypes.arrayOf(PropTypes.any.isRequired),
      value: PropTypes.any,
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string
    }).isRequired),
    value: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }).isRequired).isRequired,
  updatePosition: PropTypes.func.isRequired,
  width: PropTypes.number.isRequired,
  singleSelection: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    asPlainText: PropTypes.bool
  }).isRequired]),
  delimiter: PropTypes.string,
  zIndex: PropTypes.number
};