/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.stats.ClusterProcessor;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterIngest
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterIngest> {
    private final int numberOfPipelines;
    @Nonnull
    private final Map<String, ClusterProcessor> processorStats;
    public static final JsonpDeserializer<ClusterIngest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterIngest::setupClusterIngestDeserializer);

    private ClusterIngest(Builder builder) {
        this.numberOfPipelines = ApiTypeHelper.requireNonNull(builder.numberOfPipelines, this, "numberOfPipelines");
        this.processorStats = ApiTypeHelper.unmodifiableRequired(builder.processorStats, (Object)this, "processorStats");
    }

    public static ClusterIngest of(Function<Builder, ObjectBuilder<ClusterIngest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int numberOfPipelines() {
        return this.numberOfPipelines;
    }

    @Nonnull
    public final Map<String, ClusterProcessor> processorStats() {
        return this.processorStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("number_of_pipelines");
        generator.write(this.numberOfPipelines);
        generator.writeKey("processor_stats");
        generator.writeStartObject();
        for (Map.Entry<String, ClusterProcessor> item0 : this.processorStats.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterIngestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numberOfPipelines, JsonpDeserializer.integerDeserializer(), "number_of_pipelines");
        op.add(Builder::processorStats, JsonpDeserializer.stringMapDeserializer(ClusterProcessor._DESERIALIZER), "processor_stats");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.numberOfPipelines);
        result = 31 * result + this.processorStats.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterIngest other = (ClusterIngest)o;
        return this.numberOfPipelines == other.numberOfPipelines && this.processorStats.equals(other.processorStats);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterIngest> {
        private Integer numberOfPipelines;
        private Map<String, ClusterProcessor> processorStats;

        public Builder() {
        }

        private Builder(ClusterIngest o) {
            this.numberOfPipelines = o.numberOfPipelines;
            this.processorStats = Builder._mapCopy(o.processorStats);
        }

        private Builder(Builder o) {
            this.numberOfPipelines = o.numberOfPipelines;
            this.processorStats = Builder._mapCopy(o.processorStats);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder numberOfPipelines(int value) {
            this.numberOfPipelines = value;
            return this;
        }

        @Nonnull
        public final Builder processorStats(Map<String, ClusterProcessor> map) {
            this.processorStats = Builder._mapPutAll(this.processorStats, map);
            return this;
        }

        @Nonnull
        public final Builder processorStats(String key, ClusterProcessor value) {
            this.processorStats = Builder._mapPut(this.processorStats, key, value);
            return this;
        }

        @Nonnull
        public final Builder processorStats(String key, Function<ClusterProcessor.Builder, ObjectBuilder<ClusterProcessor>> fn) {
            return this.processorStats(key, fn.apply(new ClusterProcessor.Builder()).build());
        }

        @Override
        @Nonnull
        public ClusterIngest build() {
            this._checkSingleUse();
            return new ClusterIngest(this);
        }
    }
}

