/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralNamesBuilder;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.cryptacular.CryptUtil;
import org.cryptacular.EncodingException;
import org.cryptacular.StreamException;
import org.cryptacular.codec.Base64Encoder;
import org.cryptacular.util.CodecUtil;
import org.cryptacular.util.KeyPairUtil;
import org.cryptacular.util.StreamUtil;
import org.cryptacular.x509.ExtensionReader;
import org.cryptacular.x509.GeneralNameType;
import org.cryptacular.x509.KeyUsageBits;
import org.cryptacular.x509.dn.NameReader;
import org.cryptacular.x509.dn.StandardAttributeType;

public final class CertUtil {
    private CertUtil() {
    }

    public static String subjectCN(X509Certificate cert) throws EncodingException {
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        return new NameReader(cert).readSubject().getValue(StandardAttributeType.CommonName);
    }

    public static GeneralNames subjectAltNames(X509Certificate cert) throws EncodingException {
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        return new ExtensionReader(cert).readSubjectAlternativeName();
    }

    public static GeneralNames subjectAltNames(X509Certificate cert, GeneralNameType ... types) throws EncodingException {
        GeneralNames names;
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        CryptUtil.assertNotNullArg(types, "Types cannot be null");
        GeneralNamesBuilder builder = new GeneralNamesBuilder();
        GeneralNames altNames = CertUtil.subjectAltNames(cert);
        if (altNames != null) {
            for (GeneralName name : altNames.getNames()) {
                for (GeneralNameType type : types) {
                    if (type.ordinal() != name.getTagNo()) continue;
                    builder.addName(name);
                }
            }
        }
        if ((names = builder.build()).getNames().length == 0) {
            return null;
        }
        return names;
    }

    public static List<String> subjectNames(X509Certificate cert) throws EncodingException {
        GeneralNames altNames;
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        ArrayList<String> names = new ArrayList<String>();
        String cn = CertUtil.subjectCN(cert);
        if (cn != null) {
            names.add(cn);
        }
        if ((altNames = CertUtil.subjectAltNames(cert)) == null) {
            return names;
        }
        for (GeneralName name : altNames.getNames()) {
            names.add(name.getName().toString());
        }
        return names;
    }

    public static List<String> subjectNames(X509Certificate cert, GeneralNameType ... types) throws EncodingException {
        GeneralNames altNames;
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        CryptUtil.assertNotNullArg(types, "Types cannot be null");
        ArrayList<String> names = new ArrayList<String>();
        String cn = CertUtil.subjectCN(cert);
        if (cn != null) {
            names.add(cn);
        }
        if ((altNames = CertUtil.subjectAltNames(cert, types)) == null) {
            return names;
        }
        for (GeneralName name : altNames.getNames()) {
            names.add(name.getName().toString());
        }
        return names;
    }

    public static X509Certificate findEntityCertificate(PrivateKey key, X509Certificate ... candidates) throws EncodingException {
        CryptUtil.assertNotNullArg(key, "Private key cannot be null");
        CryptUtil.assertNotNullArg(candidates, "Certificates cannot be null");
        return CertUtil.findEntityCertificate(key, Arrays.asList(candidates));
    }

    public static X509Certificate findEntityCertificate(PrivateKey key, Collection<X509Certificate> candidates) throws EncodingException {
        CryptUtil.assertNotNullArg(key, "Private key cannot be null");
        CryptUtil.assertNotNullArg(candidates, "Certificates cannot be null");
        for (X509Certificate candidate : candidates) {
            if (!KeyPairUtil.isKeyPair(candidate.getPublicKey(), key)) continue;
            return candidate;
        }
        return null;
    }

    public static X509Certificate readCertificate(String path) throws EncodingException, StreamException {
        return CertUtil.readCertificate(StreamUtil.makeStream(new File(CryptUtil.assertNotNullArg(path, "Path cannot be null"))));
    }

    public static X509Certificate readCertificate(File file) throws EncodingException, StreamException {
        return CertUtil.readCertificate(StreamUtil.makeStream(CryptUtil.assertNotNullArg(file, "File cannot be null")));
    }

    public static X509Certificate readCertificate(InputStream in) throws EncodingException, StreamException {
        CryptUtil.assertNotNullArg(in, "Input stream cannot be null");
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)factory.generateCertificate(in);
        }
        catch (CertificateException e) {
            if (e.getCause() instanceof IOException) {
                throw new StreamException((IOException)e.getCause());
            }
            throw new EncodingException("Cannot decode certificate", e);
        }
    }

    public static X509Certificate decodeCertificate(byte[] encoded) throws EncodingException {
        return CertUtil.readCertificate(new ByteArrayInputStream(CryptUtil.assertNotNullArg(encoded, "Encoded certificate cannot be null")));
    }

    public static X509Certificate[] readCertificateChain(String path) throws EncodingException, StreamException {
        return CertUtil.readCertificateChain(StreamUtil.makeStream(new File(CryptUtil.assertNotNullArg(path, "Path cannot be null"))));
    }

    public static X509Certificate[] readCertificateChain(File file) throws EncodingException, StreamException {
        return CertUtil.readCertificateChain(StreamUtil.makeStream(CryptUtil.assertNotNullArg(file, "File cannot be null")));
    }

    public static X509Certificate[] readCertificateChain(InputStream in) throws EncodingException, StreamException {
        CryptUtil.assertNotNullArg(in, "Input stream cannot be null");
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = factory.generateCertificates(in);
            return certs.toArray(new X509Certificate[0]);
        }
        catch (CertificateException e) {
            if (e.getCause() instanceof IOException) {
                throw new StreamException((IOException)e.getCause());
            }
            throw new EncodingException("Cannot decode certificate", e);
        }
    }

    public static X509Certificate[] decodeCertificateChain(byte[] encoded) throws EncodingException {
        return CertUtil.readCertificateChain(new ByteArrayInputStream(CryptUtil.assertNotNullArg(encoded, "Encoded certificate chain cannot be null")));
    }

    public static boolean allowsUsage(X509Certificate cert, KeyUsageBits ... bits) throws EncodingException {
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        CryptUtil.assertNotNullArg(bits, "Key usage bits cannot be null");
        KeyUsage usage = new ExtensionReader(cert).readKeyUsage();
        for (KeyUsageBits bit : bits) {
            if (bit.isSet(usage)) continue;
            return false;
        }
        return true;
    }

    public static boolean allowsUsage(X509Certificate cert, KeyPurposeId ... purposes) throws EncodingException {
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        CryptUtil.assertNotNullArg(purposes, "Purposes cannot be null");
        List<KeyPurposeId> allowedUses = new ExtensionReader(cert).readExtendedKeyUsage();
        for (KeyPurposeId purpose : purposes) {
            if (allowedUses != null && allowedUses.contains(purpose)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasPolicies(X509Certificate cert, String ... policyOidsToCheck) throws EncodingException {
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        CryptUtil.assertNotNullArg(policyOidsToCheck, "Policy OIDs to check cannot be null");
        List<PolicyInformation> policies = new ExtensionReader(cert).readCertificatePolicies();
        for (String policyOid : policyOidsToCheck) {
            boolean hasPolicy = false;
            if (policies != null) {
                for (PolicyInformation policy : policies) {
                    if (!policy.getPolicyIdentifier().getId().equals(policyOid)) continue;
                    hasPolicy = true;
                    break;
                }
            }
            if (hasPolicy) continue;
            return false;
        }
        return true;
    }

    public static String subjectKeyId(X509Certificate cert) throws EncodingException {
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        return CodecUtil.hex(new ExtensionReader(cert).readSubjectKeyIdentifier().getKeyIdentifier(), true);
    }

    public static String authorityKeyId(X509Certificate cert) throws EncodingException {
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        return CodecUtil.hex(new ExtensionReader(cert).readAuthorityKeyIdentifier().getKeyIdentifierOctets(), true);
    }

    public static <T> T encodeCert(X509Certificate cert, EncodeType<T> encodeType) {
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        CryptUtil.assertNotNullArg(encodeType, "Encode type cannot be null");
        try {
            return encodeType.encode(cert);
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException("Error getting encoded X.509 certificate data", e);
        }
    }

    public static String subjectDN(X509Certificate cert, X500PrincipalFormat format) {
        CryptUtil.assertNotNullArg(cert, "Certificate cannot be null");
        X500Principal subjectX500Principal = cert.getSubjectX500Principal();
        return X500PrincipalFormat.READABLE.equals((Object)format) ? subjectX500Principal.toString() : subjectX500Principal.getName("RFC2253");
    }

    public static X509Certificate generateX509Certificate(KeyPair keyPair, String dn, Duration duration, String signatureAlgo) {
        CryptUtil.assertNotNullArg(keyPair, "Key pair cannot be null");
        CryptUtil.assertNotNullArg(dn, "DN cannot be null");
        CryptUtil.assertNotNullArg(duration, "Duration cannot be null");
        CryptUtil.assertNotNullArg(signatureAlgo, "Signature algorithm cannot be null");
        Instant now = Instant.now();
        Date notBefore = Date.from(now);
        Date notAfter = Date.from(now.plus(duration));
        return CertUtil.generateX509Certificate(keyPair, dn, notBefore, notAfter, signatureAlgo);
    }

    public static X509Certificate generateX509Certificate(KeyPair keyPair, String dn, Date notBefore, Date notAfter, String signatureAlgo) {
        CryptUtil.assertNotNullArg(keyPair, "Key pair cannot be null");
        CryptUtil.assertNotNullArg(dn, "DN cannot be null");
        CryptUtil.assertNotNullArg(notBefore, "Not before cannot be null");
        CryptUtil.assertNotNullArg(notAfter, "Not after cannot be null");
        CryptUtil.assertNotNullArg(signatureAlgo, "Signature algorithm cannot be null");
        Instant now = Instant.now();
        BigInteger serial = BigInteger.valueOf(now.toEpochMilli());
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgo).build(keyPair.getPrivate());
            X500Name x500Name = new X500Name(RFC4519Style.INSTANCE, dn);
            X509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(x500Name, serial, notBefore, notAfter, x500Name, keyPair.getPublic()).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
            return new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certificateBuilder.build(contentSigner));
        }
        catch (CertificateException | CertIOException | OperatorCreationException e) {
            throw new RuntimeException("Certificate generation error", e);
        }
    }

    public static interface EncodeType<T> {
        public static final EncodeType<byte[]> DER = new DEREncodeType();
        public static final EncodeType<String> X509 = new X509EncodeType();
        public static final EncodeType<String> PKCS7 = new PKCS7EncodeType();

        public String getType();

        public T encode(X509Certificate var1) throws CertificateEncodingException;
    }

    public static enum X500PrincipalFormat {
        RFC2253,
        READABLE;

    }

    private static final class PKCS7EncodeType
    extends AbstractPemEncodeType {
        private PKCS7EncodeType() {
        }

        @Override
        public String getType() {
            return "PKCS7";
        }

        @Override
        public String encode(X509Certificate cert) throws CertificateEncodingException {
            return this.encodePem(CryptUtil.assertNotNullArg(cert, "Certificate cannot be null").getEncoded());
        }
    }

    private static final class X509EncodeType
    extends AbstractPemEncodeType {
        private X509EncodeType() {
        }

        @Override
        public String getType() {
            return "CERTIFICATE";
        }

        @Override
        public String encode(X509Certificate cert) throws CertificateEncodingException {
            return this.encodePem(CryptUtil.assertNotNullArg(cert, "Certificate cannot be null").getEncoded());
        }
    }

    private static final class DEREncodeType
    implements EncodeType<byte[]> {
        private DEREncodeType() {
        }

        @Override
        public String getType() {
            return "DER";
        }

        @Override
        public byte[] encode(X509Certificate cert) throws CertificateEncodingException {
            return CryptUtil.assertNotNullArg(cert, "Certificate cannot be null").getEncoded();
        }
    }

    private static abstract class AbstractPemEncodeType
    implements EncodeType<String> {
        private AbstractPemEncodeType() {
        }

        protected String encodePem(byte[] der) {
            Base64Encoder encoder = new Base64Encoder(64);
            ByteBuffer input = ByteBuffer.wrap(CryptUtil.assertNotNullArg(der, "DER cannot be null"));
            CharBuffer output = CharBuffer.allocate(encoder.outputSize(der.length) + 100);
            output.append("-----BEGIN ").append(this.getType()).append("-----");
            output.append(System.lineSeparator());
            encoder.encode(input, output);
            encoder.finalize(output);
            output.flip();
            return output.toString().trim().concat(System.lineSeparator()).concat("-----END ").concat(this.getType()).concat("-----");
        }
    }
}

