/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor.pagination;

import com.google.common.hash.HashCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import org.opensearch.sql.exception.NoCursorException;
import org.opensearch.sql.executor.pagination.Cursor;
import org.opensearch.sql.planner.SerializablePlan;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.StorageEngine;

public class PlanSerializer {
    public static final String CURSOR_PREFIX = "n:";
    private final StorageEngine engine;

    public Cursor convertToCursor(PhysicalPlan plan) {
        try {
            return new Cursor(CURSOR_PREFIX + this.serialize(((SerializablePlan)((Object)plan)).getPlanForSerialization()));
        }
        catch (NotSerializableException | ClassCastException | NoCursorException e) {
            return Cursor.None;
        }
    }

    protected String serialize(Serializable object) throws NotSerializableException {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ObjectOutputStream objectOutput = new ObjectOutputStream(output);
            objectOutput.writeObject(object);
            objectOutput.flush();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(this, out){
                {
                    this.def.setLevel(9);
                }
            };
            gzip.write(output.toByteArray());
            gzip.close();
            return HashCode.fromBytes((byte[])out.toByteArray()).toString();
        }
        catch (NotSerializableException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize: " + String.valueOf(object), e);
        }
    }

    protected Serializable deserialize(String code) {
        try {
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(HashCode.fromString((String)code).asBytes()));
            CursorDeserializationStream objectInput = new CursorDeserializationStream(new ByteArrayInputStream(gzip.readAllBytes()));
            return (Serializable)objectInput.readObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to deserialize object", e);
        }
    }

    public PhysicalPlan convertToPlan(String cursor) {
        if (!cursor.startsWith(CURSOR_PREFIX)) {
            throw new UnsupportedOperationException("Unsupported cursor");
        }
        try {
            return (PhysicalPlan)((Object)this.deserialize(cursor.substring(CURSOR_PREFIX.length())));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Unsupported cursor", e);
        }
    }

    public CursorDeserializationStream getCursorDeserializationStream(InputStream in) throws IOException {
        return new CursorDeserializationStream(in);
    }

    @Generated
    public PlanSerializer(StorageEngine engine) {
        this.engine = engine;
    }

    public class CursorDeserializationStream
    extends ObjectInputStream {
        public CursorDeserializationStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        public Object resolveObject(Object obj) throws IOException {
            return obj.equals("engine") ? PlanSerializer.this.engine : obj;
        }
    }
}

