/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UHorizontalLine;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;

public class TextBlockLineBefore
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final TextBlock textBlock;
    private final char separator;
    private final TextBlock title;
    private final double defaultThickness;

    public TextBlockLineBefore(double defaultThickness, TextBlock textBlock, char separator, TextBlock title) {
        this.textBlock = textBlock;
        this.separator = separator;
        this.title = title;
        this.defaultThickness = defaultThickness;
    }

    public TextBlockLineBefore(double defaultThickness, TextBlock textBlock, char separator) {
        this(defaultThickness, textBlock, separator, null);
    }

    public TextBlockLineBefore(double defaultThickness, TextBlock textBlock) {
        this(defaultThickness, textBlock, '\u0000');
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.textBlock.calculateDimension(stringBounder);
        if (this.title != null) {
            XDimension2D dimTitle = this.title.calculateDimension(stringBounder);
            return dim.atLeast(dimTitle.getWidth() + 8.0, dimTitle.getHeight());
        }
        return dim;
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor color = ug.getParam().getColor();
        if (this.title == null) {
            UHorizontalLine.infinite(this.defaultThickness, 1.0, 1.0, this.separator).drawMe(ug);
        }
        this.textBlock.drawU(ug);
        ug = color == null ? ug.apply(HColors.none()) : ug.apply(color);
        if (this.title != null) {
            UHorizontalLine.infinite(this.defaultThickness, 1.0, 1.0, this.title, this.separator).drawMe(ug);
        }
    }

    @Override
    public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
        return this.textBlock.getInnerPosition(member, stringBounder);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        if (this.textBlock instanceof WithPorts) {
            return ((WithPorts)((Object)this.textBlock)).getPorts(stringBounder);
        }
        return new Ports();
    }
}

