/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.http;

import java.text.MessageFormat;
import java.util.BitSet;
import java.util.ResourceBundle;

class CookieNameValidator {
    private static final String LSTRING_FILE = "jakarta.servlet.http.LocalStrings";
    protected static final ResourceBundle lStrings = ResourceBundle.getBundle("jakarta.servlet.http.LocalStrings");
    protected final BitSet allowed = new BitSet(128);

    protected CookieNameValidator(String string) {
        this.allowed.set(32, 127);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            this.allowed.clear(c);
        }
    }

    void validate(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(lStrings.getString("err.cookie_name_blank"));
        }
        if (!this.isToken(string)) {
            String string2 = lStrings.getString("err.cookie_name_is_token");
            throw new IllegalArgumentException(MessageFormat.format(string2, string));
        }
    }

    boolean isToken(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (this.allowed.get(c)) continue;
            return false;
        }
        return true;
    }
}

