/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes;

import java.util.ArrayList;
import org.apache.catalina.tribes.Member;

public class ChannelException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected static final FaultyMember[] EMPTY_LIST = new FaultyMember[0];
    private ArrayList<FaultyMember> faultyMembers = null;

    public ChannelException() {
    }

    public ChannelException(String string) {
        super(string);
    }

    public ChannelException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public ChannelException(Throwable throwable) {
        super(throwable);
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder(super.getMessage());
        if (this.faultyMembers == null || this.faultyMembers.isEmpty()) {
            stringBuilder.append("; No faulty members identified.");
        } else {
            stringBuilder.append("; Faulty members:");
            for (FaultyMember faultyMember : this.faultyMembers) {
                stringBuilder.append(faultyMember.getMember().getName());
                stringBuilder.append("; ");
            }
        }
        return stringBuilder.toString();
    }

    public boolean addFaultyMember(Member member, Exception exception) {
        return this.addFaultyMember(new FaultyMember(member, exception));
    }

    public int addFaultyMember(FaultyMember[] faultyMemberArray) {
        int n = 0;
        for (int i = 0; faultyMemberArray != null && i < faultyMemberArray.length; ++i) {
            if (!this.addFaultyMember(faultyMemberArray[i])) continue;
            ++n;
        }
        return n;
    }

    public boolean addFaultyMember(FaultyMember faultyMember) {
        if (this.faultyMembers == null) {
            this.faultyMembers = new ArrayList();
        }
        if (!this.faultyMembers.contains(faultyMember)) {
            return this.faultyMembers.add(faultyMember);
        }
        return false;
    }

    public FaultyMember[] getFaultyMembers() {
        if (this.faultyMembers == null) {
            return EMPTY_LIST;
        }
        return this.faultyMembers.toArray(new FaultyMember[0]);
    }

    public static class FaultyMember {
        protected final Exception cause;
        protected final Member member;

        public FaultyMember(Member member, Exception exception) {
            this.member = member;
            this.cause = exception;
        }

        public Member getMember() {
            return this.member;
        }

        public Exception getCause() {
            return this.cause;
        }

        public String toString() {
            return "FaultyMember:" + this.member.toString();
        }

        public int hashCode() {
            return this.member != null ? this.member.hashCode() : 0;
        }

        public boolean equals(Object object) {
            if (this.member == null || !(object instanceof FaultyMember) || ((FaultyMember)object).member == null) {
                return false;
            }
            return this.member.equals(((FaultyMember)object).member);
        }
    }
}

