﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/route53resolver/Route53Resolver_EXPORTS.h>
#include <aws/route53resolver/model/IpAddressStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Route53Resolver {
namespace Model {

/**
 * <p>In the response to a <a
 * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html">GetResolverEndpoint</a>
 * request, information about the IP addresses that the Resolver endpoint uses for
 * DNS queries.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/IpAddressResponse">AWS
 * API Reference</a></p>
 */
class IpAddressResponse {
 public:
  AWS_ROUTE53RESOLVER_API IpAddressResponse() = default;
  AWS_ROUTE53RESOLVER_API IpAddressResponse(Aws::Utils::Json::JsonView jsonValue);
  AWS_ROUTE53RESOLVER_API IpAddressResponse& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ROUTE53RESOLVER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of one IP address.</p>
   */
  inline const Aws::String& GetIpId() const { return m_ipId; }
  inline bool IpIdHasBeenSet() const { return m_ipIdHasBeenSet; }
  template <typename IpIdT = Aws::String>
  void SetIpId(IpIdT&& value) {
    m_ipIdHasBeenSet = true;
    m_ipId = std::forward<IpIdT>(value);
  }
  template <typename IpIdT = Aws::String>
  IpAddressResponse& WithIpId(IpIdT&& value) {
    SetIpId(std::forward<IpIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of one subnet.</p>
   */
  inline const Aws::String& GetSubnetId() const { return m_subnetId; }
  inline bool SubnetIdHasBeenSet() const { return m_subnetIdHasBeenSet; }
  template <typename SubnetIdT = Aws::String>
  void SetSubnetId(SubnetIdT&& value) {
    m_subnetIdHasBeenSet = true;
    m_subnetId = std::forward<SubnetIdT>(value);
  }
  template <typename SubnetIdT = Aws::String>
  IpAddressResponse& WithSubnetId(SubnetIdT&& value) {
    SetSubnetId(std::forward<SubnetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>One IPv4 address that the Resolver endpoint uses for DNS queries.</p>
   */
  inline const Aws::String& GetIp() const { return m_ip; }
  inline bool IpHasBeenSet() const { return m_ipHasBeenSet; }
  template <typename IpT = Aws::String>
  void SetIp(IpT&& value) {
    m_ipHasBeenSet = true;
    m_ip = std::forward<IpT>(value);
  }
  template <typename IpT = Aws::String>
  IpAddressResponse& WithIp(IpT&& value) {
    SetIp(std::forward<IpT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> One IPv6 address that the Resolver endpoint uses for DNS queries. </p>
   */
  inline const Aws::String& GetIpv6() const { return m_ipv6; }
  inline bool Ipv6HasBeenSet() const { return m_ipv6HasBeenSet; }
  template <typename Ipv6T = Aws::String>
  void SetIpv6(Ipv6T&& value) {
    m_ipv6HasBeenSet = true;
    m_ipv6 = std::forward<Ipv6T>(value);
  }
  template <typename Ipv6T = Aws::String>
  IpAddressResponse& WithIpv6(Ipv6T&& value) {
    SetIpv6(std::forward<Ipv6T>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A status code that gives the current status of the request.</p>
   */
  inline IpAddressStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(IpAddressStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline IpAddressResponse& WithStatus(IpAddressStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A message that provides additional information about the status of the
   * request.</p>
   */
  inline const Aws::String& GetStatusMessage() const { return m_statusMessage; }
  inline bool StatusMessageHasBeenSet() const { return m_statusMessageHasBeenSet; }
  template <typename StatusMessageT = Aws::String>
  void SetStatusMessage(StatusMessageT&& value) {
    m_statusMessageHasBeenSet = true;
    m_statusMessage = std::forward<StatusMessageT>(value);
  }
  template <typename StatusMessageT = Aws::String>
  IpAddressResponse& WithStatusMessage(StatusMessageT&& value) {
    SetStatusMessage(std::forward<StatusMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that the IP address was created, in Unix time format and
   * Coordinated Universal Time (UTC).</p>
   */
  inline const Aws::String& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::String>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::String>
  IpAddressResponse& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The date and time that the IP address was last modified, in Unix time format
   * and Coordinated Universal Time (UTC).</p>
   */
  inline const Aws::String& GetModificationTime() const { return m_modificationTime; }
  inline bool ModificationTimeHasBeenSet() const { return m_modificationTimeHasBeenSet; }
  template <typename ModificationTimeT = Aws::String>
  void SetModificationTime(ModificationTimeT&& value) {
    m_modificationTimeHasBeenSet = true;
    m_modificationTime = std::forward<ModificationTimeT>(value);
  }
  template <typename ModificationTimeT = Aws::String>
  IpAddressResponse& WithModificationTime(ModificationTimeT&& value) {
    SetModificationTime(std::forward<ModificationTimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_ipId;

  Aws::String m_subnetId;

  Aws::String m_ip;

  Aws::String m_ipv6;

  IpAddressStatus m_status{IpAddressStatus::NOT_SET};

  Aws::String m_statusMessage;

  Aws::String m_creationTime;

  Aws::String m_modificationTime;
  bool m_ipIdHasBeenSet = false;
  bool m_subnetIdHasBeenSet = false;
  bool m_ipHasBeenSet = false;
  bool m_ipv6HasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_statusMessageHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_modificationTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Route53Resolver
}  // namespace Aws
